
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.History.TransactionInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:dateTime" name="SystemDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LastDateToPurchase" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="LocalDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpiryDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InputEntry" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteHistoryTransactionInfo implements Serializable
{
    private Date systemDateTime;
    private Date lastDateToPurchase;
    private Date localDateTime;
    private Date expiryDateTime;
    private String inputEntry;

    /** 
     * Get the 'SystemDateTime' element value. System Date/time the PQ was created
    					Ref: DM0Z_65_CLDB and
    					DM0Z_65_CLTB
    					DM0Z_65_ULDB
    					DM0Z_65_ULTB
     * 
     * @return value
     */
    public Date getSystemDateTime() {
        return systemDateTime;
    }

    /** 
     * Set the 'SystemDateTime' element value. System Date/time the PQ was created
    					Ref: DM0Z_65_CLDB and
    					DM0Z_65_CLTB
    					DM0Z_65_ULDB
    					DM0Z_65_ULTB
     * 
     * @param systemDateTime
     */
    public void setSystemDateTime(Date systemDateTime) {
        this.systemDateTime = systemDateTime;
    }

    /** 
     * Get the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
     * 
     * @return value
     */
    public Date getLastDateToPurchase() {
        return lastDateToPurchase;
    }

    /** 
     * Set the 'LastDateToPurchase' element value. Time Stamp for Last Date by when the PQ has to be purchased. Ref:DM0Z_40_TMST
     * 
     * @param lastDateToPurchase
     */
    public void setLastDateToPurchase(Date lastDateToPurchase) {
        this.lastDateToPurchase = lastDateToPurchase;
    }

    /** 
     * Get the 'LocalDateTime' element value. Local Create Date/time the PQ was updated.
    					Ref: SR06PQ-20_CLDB/CTIM
    					SR06PQ-20_ULDB/ULTB
     * 
     * @return value
     */
    public Date getLocalDateTime() {
        return localDateTime;
    }

    /** 
     * Set the 'LocalDateTime' element value. Local Create Date/time the PQ was updated.
    					Ref: SR06PQ-20_CLDB/CTIM
    					SR06PQ-20_ULDB/ULTB
     * 
     * @param localDateTime
     */
    public void setLocalDateTime(Date localDateTime) {
        this.localDateTime = localDateTime;
    }

    /** 
     * Get the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
     * 
     * @return value
     */
    public Date getExpiryDateTime() {
        return expiryDateTime;
    }

    /** 
     * Set the 'ExpiryDateTime' element value. Price quote expiry Date/time the PQ. Ref: DM0Z_40_PXDT/DM0Z_40_PXTM
     * 
     * @param expiryDateTime
     */
    public void setExpiryDateTime(Date expiryDateTime) {
        this.expiryDateTime = expiryDateTime;
    }

    /** 
     * Get the 'InputEntry' element value. Entry made to update the price quote.
    					Ref: DM0Z_E0_IMGE
     * 
     * @return value
     */
    public String getInputEntry() {
        return inputEntry;
    }

    /** 
     * Set the 'InputEntry' element value. Entry made to update the price quote.
    					Ref: DM0Z_E0_IMGE
     * 
     * @param inputEntry
     */
    public void setInputEntry(String inputEntry) {
        this.inputEntry = inputEntry;
    }
}
