
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Indicators">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Indicators.ManualPricing" name="ManualPricing" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ViewershipCategory" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="segmentSelect"/>
 *   &lt;xs:attribute type="xs:boolean" name="ticketed"/>
 *   &lt;xs:attribute type="xs:boolean" name="override"/>
 *   &lt;xs:attribute type="xs:boolean" name="deleted"/>
 *   &lt;xs:attribute type="xs:boolean" name="itineraryChange"/>
 *   &lt;xs:attribute type="xs:boolean" name="isExpired"/>
 *   &lt;xs:attribute type="xs:boolean" name="exchange"/>
 *   &lt;xs:attribute type="xs:boolean" name="reissue"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteIndicators implements Serializable
{
    private IndicatorsManualPricing manualPricing;
    private List<String> viewershipCategoryList = new ArrayList<String>();
    private Boolean segmentSelect;
    private Boolean ticketed;
    private Boolean override;
    private Boolean deleted;
    private Boolean itineraryChange;
    private Boolean isExpired;
    private Boolean exchange;
    private Boolean reissue;

    /** 
     * Get the 'ManualPricing' element value.
     * 
     * @return value
     */
    public IndicatorsManualPricing getManualPricing() {
        return manualPricing;
    }

    /** 
     * Set the 'ManualPricing' element value.
     * 
     * @param manualPricing
     */
    public void setManualPricing(IndicatorsManualPricing manualPricing) {
        this.manualPricing = manualPricing;
    }

    /** 
     * Get the list of 'ViewershipCategory' element items. XXX - Retailer agent display on wholesaler PQ
     * 
     * @return list
     */
    public List<String> getViewershipCategoryList() {
        return viewershipCategoryList;
    }

    /** 
     * Set the list of 'ViewershipCategory' element items. XXX - Retailer agent display on wholesaler PQ
     * 
     * @param list
     */
    public void setViewershipCategoryList(List<String> list) {
        viewershipCategoryList = list;
    }

    /** 
     * Get the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
    			
     * 
     * @return value
     */
    public Boolean getSegmentSelect() {
        return segmentSelect;
    }

    /** 
     * Set the 'segmentSelect' attribute value. Indicator to specify itinerary  was priced by selecting segment
    			
     * 
     * @param segmentSelect
     */
    public void setSegmentSelect(Boolean segmentSelect) {
        this.segmentSelect = segmentSelect;
    }

    /** 
     * Get the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
    			
     * 
     * @return value
     */
    public Boolean getTicketed() {
        return ticketed;
    }

    /** 
     * Set the 'ticketed' attribute value. Indicator to specify PQ has been ticketed
    			
     * 
     * @param ticketed
     */
    public void setTicketed(Boolean ticketed) {
        this.ticketed = ticketed;
    }

    /** 
     * Get the 'override' attribute value. Indicator to specify PQ has been override
    			
     * 
     * @return value
     */
    public Boolean getOverride() {
        return override;
    }

    /** 
     * Set the 'override' attribute value. Indicator to specify PQ has been override
    			
     * 
     * @param override
     */
    public void setOverride(Boolean override) {
        this.override = override;
    }

    /** 
     * Get the 'deleted' attribute value. Specifies that this is a deleted PQ
     * 
     * @return value
     */
    public Boolean getDeleted() {
        return deleted;
    }

    /** 
     * Set the 'deleted' attribute value. Specifies that this is a deleted PQ
     * 
     * @param deleted
     */
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    /** 
     * Get the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
     * 
     * @return value
     */
    public Boolean getItineraryChange() {
        return itineraryChange;
    }

    /** 
     * Set the 'itineraryChange' attribute value. Indicator to specify that the itinerary has changed
     * 
     * @param itineraryChange
     */
    public void setItineraryChange(Boolean itineraryChange) {
        this.itineraryChange = itineraryChange;
    }

    /** 
     * Get the 'isExpired' attribute value. Set to true when agency local date  is greater than purchase date DM0Z_65_PURD(DM0Z_65_ID05 = X'01') else greater than updated date DM0Z_65_ULDB
     * 
     * @return value
     */
    public Boolean getIsExpired() {
        return isExpired;
    }

    /** 
     * Set the 'isExpired' attribute value. Set to true when agency local date  is greater than purchase date DM0Z_65_PURD(DM0Z_65_ID05 = X'01') else greater than updated date DM0Z_65_ULDB
     * 
     * @param isExpired
     */
    public void setIsExpired(Boolean isExpired) {
        this.isExpired = isExpired;
    }

    /** 
     * Get the 'exchange' attribute value. Indicator to specify if exchange PQR
    				Ref: DM0Z_40_QRXP, #DM0Z_40_EXNG
    			
     * 
     * @return value
     */
    public Boolean getExchange() {
        return exchange;
    }

    /** 
     * Set the 'exchange' attribute value. Indicator to specify if exchange PQR
    				Ref: DM0Z_40_QRXP, #DM0Z_40_EXNG
    			
     * 
     * @param exchange
     */
    public void setExchange(Boolean exchange) {
        this.exchange = exchange;
    }

    /** 
     * Get the 'reissue' attribute value. Indicator to specify if reissue PQR
    				Ref: DM0Z_40_QRXP, #DM0Z_40_REIS
    			
     * 
     * @return value
     */
    public Boolean getReissue() {
        return reissue;
    }

    /** 
     * Set the 'reissue' attribute value. Indicator to specify if reissue PQR
    				Ref: DM0Z_40_QRXP, #DM0Z_40_REIS
    			
     * 
     * @param reissue
     */
    public void setReissue(Boolean reissue) {
        this.reissue = reissue;
    }
}
