
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteInfo.SearchParameters">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Reservation.Type.Short" name="Reservation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Status" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Code.PQType" name="Type" minOccurs="0"/>
 *     &lt;xs:group ref="ns:SearchParameterChoice.CG"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteInfoSearchParameters implements Serializable
{
    private ReservationTypeShort reservation;
    private List<String> statuList = new ArrayList<String>();
    private CodePQType type;
    private SearchParameterChoiceCG searchParameterChoiceCG;

    /** 
     * Get the 'Reservation' element value. PNR in which the price Quote is stored
     * 
     * @return value
     */
    public ReservationTypeShort getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value. PNR in which the price Quote is stored
     * 
     * @param reservation
     */
    public void setReservation(ReservationTypeShort reservation) {
        this.reservation = reservation;
    }

    /** 
     * Get the list of 'Status' element items. PQ status -
    Valid Status:
    A =Active (airline and agencies)
    I = Inactive (airline only)
    X = Expired (airlines only)
    M = Manual (airlines only)
    D = Deleted (agencies only)
    H = History (airlines only)
     * 
     * @return list
     */
    public List<String> getStatuList() {
        return statuList;
    }

    /** 
     * Set the list of 'Status' element items. PQ status -
    Valid Status:
    A =Active (airline and agencies)
    I = Inactive (airline only)
    X = Expired (airlines only)
    M = Manual (airlines only)
    D = Deleted (agencies only)
    H = History (airlines only)
     * 
     * @param list
     */
    public void setStatuList(List<String> list) {
        statuList = list;
    }

    /** 
     * Get the 'Type' element value. Price Quote Type
    					Possible values can be:
    					PQ - Price Quote
    					PQR - Price Quote Reissue
    					PQRE - PQR Exchange
    					PQRR - RQR Refund
    					If not specified, it defaults to PQ and PQR
    				
     * 
     * @return value
     */
    public CodePQType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Price Quote Type
    					Possible values can be:
    					PQ - Price Quote
    					PQR - Price Quote Reissue
    					PQRE - PQR Exchange
    					PQRR - RQR Refund
    					If not specified, it defaults to PQ and PQR
    				
     * 
     * @param type
     */
    public void setType(CodePQType type) {
        this.type = type;
    }

    /** 
     * Get the 'SearchParameterChoice.CG' group value.
     * 
     * @return value
     */
    public SearchParameterChoiceCG getSearchParameterChoiceCG() {
        return searchParameterChoiceCG;
    }

    /** 
     * Set the 'SearchParameterChoice.CG' group value.
     * 
     * @param searchParameterChoiceCG
     */
    public void setSearchParameterChoiceCG(
            SearchParameterChoiceCG searchParameterChoiceCG) {
        this.searchParameterChoiceCG = searchParameterChoiceCG;
    }
}
