
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteInfo.Update.Response">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Reservation.Type.Optional" name="Reservation" minOccurs="0"/>
 *     &lt;xs:element type="ns:UpdatePriceQuote.Response.NameAssociation" name="UpdatedNameAssociation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Response.Details" name="Details" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteInfoUpdateResponse implements Serializable
{
    private ReservationTypeOptional reservation;
    private List<UpdatePriceQuoteResponseNameAssociation> updatedNameAssociationList = new ArrayList<UpdatePriceQuoteResponseNameAssociation>();
    private List<PriceQuoteResponseDetails> detailList = new ArrayList<PriceQuoteResponseDetails>();

    /** 
     * Get the 'Reservation' element value. Reservation identifier as generated in the host system
     * 
     * @return value
     */
    public ReservationTypeOptional getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value. Reservation identifier as generated in the host system
     * 
     * @param reservation
     */
    public void setReservation(ReservationTypeOptional reservation) {
        this.reservation = reservation;
    }

    /** 
     * Get the list of 'UpdatedNameAssociation' element items. Name Association information modified with the UpdateNameAssociation request
     * 
     * @return list
     */
    public List<UpdatePriceQuoteResponseNameAssociation> getUpdatedNameAssociationList() {
        return updatedNameAssociationList;
    }

    /** 
     * Set the list of 'UpdatedNameAssociation' element items. Name Association information modified with the UpdateNameAssociation request
     * 
     * @param list
     */
    public void setUpdatedNameAssociationList(
            List<UpdatePriceQuoteResponseNameAssociation> list) {
        updatedNameAssociationList = list;
    }

    /** 
     * Get the list of 'Details' element items.
     * 
     * @return list
     */
    public List<PriceQuoteResponseDetails> getDetailList() {
        return detailList;
    }

    /** 
     * Set the list of 'Details' element items.
     * 
     * @param list
     */
    public void setDetailList(List<PriceQuoteResponseDetails> list) {
        detailList = list;
    }
}
