
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Item.Fee.Details">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Item.OBFee.Details" name="OBFee" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element name="ChangeFee" minOccurs="0">
 *       &lt;!-- Reference to inner class ChangeFee -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OtherFee" minOccurs="0">
 *       &lt;!-- Reference to inner class OtherFee -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteItemFeeDetails implements Serializable
{
    private List<PriceQuoteItemOBFeeDetails> OBFeeList = new ArrayList<PriceQuoteItemOBFeeDetails>();
    private ChangeFee changeFee;
    private OtherFee otherFee;

    /** 
     * Get the list of 'OBFee' element items. Fee details defined in Price Quote
     * 
     * @return list
     */
    public List<PriceQuoteItemOBFeeDetails> getOBFeeList() {
        return OBFeeList;
    }

    /** 
     * Set the list of 'OBFee' element items. Fee details defined in Price Quote
     * 
     * @param list
     */
    public void setOBFeeList(List<PriceQuoteItemOBFeeDetails> list) {
        OBFeeList = list;
    }

    /** 
     * Get the 'ChangeFee' element value.
     * 
     * @return value
     */
    public ChangeFee getChangeFee() {
        return changeFee;
    }

    /** 
     * Set the 'ChangeFee' element value.
     * 
     * @param changeFee
     */
    public void setChangeFee(ChangeFee changeFee) {
        this.changeFee = changeFee;
    }

    /** 
     * Get the 'OtherFee' element value.
     * 
     * @return value
     */
    public OtherFee getOtherFee() {
        return otherFee;
    }

    /** 
     * Set the 'OtherFee' element value.
     * 
     * @param otherFee
     */
    public void setOtherFee(OtherFee otherFee) {
        this.otherFee = otherFee;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeFee" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
     *       &lt;xs:element name="FeeTax" minOccurs="0" maxOccurs="4">
     *         &lt;!-- Reference to inner class FeeTax -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="WaiverCode" minOccurs="0"/>
     *       &lt;xs:element type="ns:Amount" name="AmountCollected" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" name="waived"/>
     *     &lt;xs:attribute name="collectionMethod">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class CollectionMethod -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *     &lt;xs:attribute type="xs:string" name="code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ChangeFee implements Serializable
    {
        private Amount amount;
        private List<FeeTax> feeTaxList = new ArrayList<FeeTax>();
        private String waiverCode;
        private Amount amountCollected;
        private Boolean waived;
        private CollectionMethod collectionMethod;
        private String code;

        /** 
         * Get the 'Amount' element value. Ref: DM0Z_C0_CFMT
         * 
         * @return value
         */
        public Amount getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Ref: DM0Z_C0_CFMT
         * 
         * @param amount
         */
        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        /** 
         * Get the list of 'FeeTax' element items.
         * 
         * @return list
         */
        public List<FeeTax> getFeeTaxList() {
            return feeTaxList;
        }

        /** 
         * Set the list of 'FeeTax' element items.
         * 
         * @param list
         */
        public void setFeeTaxList(List<FeeTax> list) {
            feeTaxList = list;
        }

        /** 
         * Get the 'WaiverCode' element value.
         * 
         * @return value
         */
        public String getWaiverCode() {
            return waiverCode;
        }

        /** 
         * Set the 'WaiverCode' element value.
         * 
         * @param waiverCode
         */
        public void setWaiverCode(String waiverCode) {
            this.waiverCode = waiverCode;
        }

        /** 
         * Get the 'AmountCollected' element value. Applicable for TN
        								and when collectionMethod
        								is EMD or OtherDoc
         * 
         * @return value
         */
        public Amount getAmountCollected() {
            return amountCollected;
        }

        /** 
         * Set the 'AmountCollected' element value. Applicable for TN
        								and when collectionMethod
        								is EMD or OtherDoc
         * 
         * @param amountCollected
         */
        public void setAmountCollected(Amount amountCollected) {
            this.amountCollected = amountCollected;
        }

        /** 
         * Get the 'waived' attribute value. Indicates if change fee waived
         * 
         * @return value
         */
        public Boolean getWaived() {
            return waived;
        }

        /** 
         * Set the 'waived' attribute value. Indicates if change fee waived
         * 
         * @param waived
         */
        public void setWaived(Boolean waived) {
            this.waived = waived;
        }

        /** 
         * Get the 'collectionMethod' attribute value. - Tax
        							- EMD
        							- OtherDoc
        							- InTotal
        							Ref: DM0Z_40_QRXP
        							DM0Z_B9_CIND
         * 
         * @return value
         */
        public CollectionMethod getCollectionMethod() {
            return collectionMethod;
        }

        /** 
         * Set the 'collectionMethod' attribute value. - Tax
        							- EMD
        							- OtherDoc
        							- InTotal
        							Ref: DM0Z_40_QRXP
        							DM0Z_B9_CIND
         * 
         * @param collectionMethod
         */
        public void setCollectionMethod(CollectionMethod collectionMethod) {
            this.collectionMethod = collectionMethod;
        }

        /** 
         * Get the 'code' attribute value. Applicable for TN when collectedMethod is Tax
        							Ref: #DM0Z_C5_CFAT
        							DM0Z_C5_TIDE
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Applicable for TN when collectedMethod is Tax
        							Ref: #DM0Z_C5_CFAT
        							DM0Z_C5_TIDE
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeTax" minOccurs="0" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:Amount" name="Amount"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:string" use="required" name="code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FeeTax implements Serializable
        {
            private Amount amount;
            private String code;

            /** 
             * Get the 'Amount' element value. Ref: DM0Z_C5_CAMT
             * 
             * @return value
             */
            public Amount getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value. Ref: DM0Z_C5_CAMT
             * 
             * @param amount
             */
            public void setAmount(Amount amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'code' attribute value. Ref: DM0Z_C5_TXID
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'code' attribute value. Ref: DM0Z_C5_TXID
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="Tax"/>
         *     &lt;xs:enumeration value="EMD"/>
         *     &lt;xs:enumeration value="OtherDoc"/>
         *     &lt;xs:enumeration value="InTotal"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum CollectionMethod implements Serializable {
            TAX("Tax"), EMD("EMD"), OTHER_DOC("OtherDoc"), IN_TOTAL("InTotal");
            private final String value;

            private CollectionMethod(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static CollectionMethod convert(String value) {
                for (CollectionMethod inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherFee" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="code"/>
     *     &lt;xs:attribute type="xs:boolean" name="waived"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherFee implements Serializable
    {
        private Amount amount;
        private String code;
        private Boolean waived;

        /** 
         * Get the 'Amount' element value. Ref:
        								TN - DM0Z_C0_TFTA
        								AS -  DM0Z_C0_LFMT
         * 
         * @return value
         */
        public Amount getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Ref:
        								TN - DM0Z_C0_TFTA
        								AS -  DM0Z_C0_LFMT
         * 
         * @param amount
         */
        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'code' attribute value. Applicable for TN
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value. Applicable for TN
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'waived' attribute value.
         * 
         * @return value
         */
        public Boolean getWaived() {
            return waived;
        }

        /** 
         * Set the 'waived' attribute value.
         * 
         * @param waived
         */
        public void setWaived(Boolean waived) {
            this.waived = waived;
        }
    }
}
