
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Item.Fee.RemoveAssociation">
 *   &lt;xs:attribute type="xs:string" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="code"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="itemId"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteItemFeeRemoveAssociation implements Serializable
{
    private String type;
    private String code;
    private BigInteger itemId;

    /** 
     * Get the 'type' attribute value. Group or type which the fee belongs to.

    				Possible Values:
    				OB
    			
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Group or type which the fee belongs to.

    				Possible Values:
    				OB
    			
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'code' attribute value. Code associated to the fee.

    				Possible values:
    				R01
    				R02-R12
    				T01
    				T02-T20
    			
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Code associated to the fee.

    				Possible values:
    				R01
    				R02-R12
    				T01
    				T02-T20
    			
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'itemId' attribute value. Fee item sequence number that uniquely identifies this fee association to the name
     * 
     * @return value
     */
    public BigInteger getItemId() {
        return itemId;
    }

    /** 
     * Set the 'itemId' attribute value. Fee item sequence number that uniquely identifies this fee association to the name
     * 
     * @param itemId
     */
    public void setItemId(BigInteger itemId) {
        this.itemId = itemId;
    }
}
