
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Response.Details">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Details.AgentInfo" name="AgentInfo"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.TransactionInfo" name="TransactionInfo"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.NameAssociationInfo" name="NameAssociationInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.SegmentInfo" name="SegmentInfo" minOccurs="0" maxOccurs="30"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.FareInfo" name="FareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.AdditionalFareInfo" name="AdditionalFareInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Item.Fee.Details" name="FeeInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.MiscellaneousInfo" name="MiscellaneousInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.PaymentInfo" name="PaymentInfo" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.MessageInfo" name="MessageInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceQuote.Details.HistoryInfo" name="HistoryInfo" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:Code.PQType" use="required" name="type"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:string" name="passengerType"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="status"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="pricingType"/>
 *   &lt;xs:attribute type="xs:string" name="pricingStatus"/>
 *   &lt;xs:attribute type="xs:boolean" name="displayOnly"/>
 *   &lt;xs:attribute type="xs:boolean" name="lowCostCarrier"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteResponseDetails implements Serializable
{
    private PriceQuoteDetailsAgentInfo agentInfo;
    private PriceQuoteDetailsTransactionInfo transactionInfo;
    private List<PriceQuoteDetailsNameAssociationInfo> nameAssociationInfoList = new ArrayList<PriceQuoteDetailsNameAssociationInfo>();
    private List<PriceQuoteDetailsSegmentInfo> segmentInfoList = new ArrayList<PriceQuoteDetailsSegmentInfo>();
    private PriceQuoteDetailsFareInfo fareInfo;
    private PriceQuoteDetailsAdditionalFareInfo additionalFareInfo;
    private List<PriceQuoteItemFeeDetails> feeInfoList = new ArrayList<PriceQuoteItemFeeDetails>();
    private PriceQuoteDetailsMiscellaneousInfo miscellaneousInfo;
    private List<PriceQuoteDetailsPaymentInfo> paymentInfoList = new ArrayList<PriceQuoteDetailsPaymentInfo>();
    private PriceQuoteDetailsMessageInfo messageInfo;
    private List<PriceQuoteDetailsHistoryInfo> historyInfoList = new ArrayList<PriceQuoteDetailsHistoryInfo>();
    private CodePQType type;
    private BigInteger number;
    private String passengerType;
    private String status;
    private String pricingType;
    private String pricingStatus;
    private Boolean displayOnly;
    private Boolean lowCostCarrier;

    /** 
     * Get the 'AgentInfo' element value. Information about the agent who created the PQ
     * 
     * @return value
     */
    public PriceQuoteDetailsAgentInfo getAgentInfo() {
        return agentInfo;
    }

    /** 
     * Set the 'AgentInfo' element value. Information about the agent who created the PQ
     * 
     * @param agentInfo
     */
    public void setAgentInfo(PriceQuoteDetailsAgentInfo agentInfo) {
        this.agentInfo = agentInfo;
    }

    /** 
     * Get the 'TransactionInfo' element value. Data at PQ transaction
    					level
     * 
     * @return value
     */
    public PriceQuoteDetailsTransactionInfo getTransactionInfo() {
        return transactionInfo;
    }

    /** 
     * Set the 'TransactionInfo' element value. Data at PQ transaction
    					level
     * 
     * @param transactionInfo
     */
    public void setTransactionInfo(
            PriceQuoteDetailsTransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    /** 
     * Get the list of 'NameAssociationInfo' element items. List of associated traveler names
    					for this PQ
     * 
     * @return list
     */
    public List<PriceQuoteDetailsNameAssociationInfo> getNameAssociationInfoList() {
        return nameAssociationInfoList;
    }

    /** 
     * Set the list of 'NameAssociationInfo' element items. List of associated traveler names
    					for this PQ
     * 
     * @param list
     */
    public void setNameAssociationInfoList(
            List<PriceQuoteDetailsNameAssociationInfo> list) {
        nameAssociationInfoList = list;
    }

    /** 
     * Get the list of 'SegmentInfo' element items. Data associated to the segments priced within the PQ
     * 
     * @return list
     */
    public List<PriceQuoteDetailsSegmentInfo> getSegmentInfoList() {
        return segmentInfoList;
    }

    /** 
     * Set the list of 'SegmentInfo' element items. Data associated to the segments priced within the PQ
     * 
     * @param list
     */
    public void setSegmentInfoList(List<PriceQuoteDetailsSegmentInfo> list) {
        segmentInfoList = list;
    }

    /** 
     * Get the 'FareInfo' element value. Fare details associated to the selling fare equivalent *PQ
     * 
     * @return value
     */
    public PriceQuoteDetailsFareInfo getFareInfo() {
        return fareInfo;
    }

    /** 
     * Set the 'FareInfo' element value. Fare details associated to the selling fare equivalent *PQ
     * 
     * @param fareInfo
     */
    public void setFareInfo(PriceQuoteDetailsFareInfo fareInfo) {
        this.fareInfo = fareInfo;
    }

    /** 
     * Get the 'AdditionalFareInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteDetailsAdditionalFareInfo getAdditionalFareInfo() {
        return additionalFareInfo;
    }

    /** 
     * Set the 'AdditionalFareInfo' element value.
     * 
     * @param additionalFareInfo
     */
    public void setAdditionalFareInfo(
            PriceQuoteDetailsAdditionalFareInfo additionalFareInfo) {
        this.additionalFareInfo = additionalFareInfo;
    }

    /** 
     * Get the list of 'FeeInfo' element items. Fee details defined in Price Quote
     * 
     * @return list
     */
    public List<PriceQuoteItemFeeDetails> getFeeInfoList() {
        return feeInfoList;
    }

    /** 
     * Set the list of 'FeeInfo' element items. Fee details defined in Price Quote
     * 
     * @param list
     */
    public void setFeeInfoList(List<PriceQuoteItemFeeDetails> list) {
        feeInfoList = list;
    }

    /** 
     * Get the 'MiscellaneousInfo' element value. Miscellaneous details pertaining to this PQ
     * 
     * @return value
     */
    public PriceQuoteDetailsMiscellaneousInfo getMiscellaneousInfo() {
        return miscellaneousInfo;
    }

    /** 
     * Set the 'MiscellaneousInfo' element value. Miscellaneous details pertaining to this PQ
     * 
     * @param miscellaneousInfo
     */
    public void setMiscellaneousInfo(
            PriceQuoteDetailsMiscellaneousInfo miscellaneousInfo) {
        this.miscellaneousInfo = miscellaneousInfo;
    }

    /** 
     * Get the list of 'PaymentInfo' element items.
     * 
     * @return list
     */
    public List<PriceQuoteDetailsPaymentInfo> getPaymentInfoList() {
        return paymentInfoList;
    }

    /** 
     * Set the list of 'PaymentInfo' element items.
     * 
     * @param list
     */
    public void setPaymentInfoList(List<PriceQuoteDetailsPaymentInfo> list) {
        paymentInfoList = list;
    }

    /** 
     * Get the 'MessageInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteDetailsMessageInfo getMessageInfo() {
        return messageInfo;
    }

    /** 
     * Set the 'MessageInfo' element value.
     * 
     * @param messageInfo
     */
    public void setMessageInfo(PriceQuoteDetailsMessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    /** 
     * Get the list of 'HistoryInfo' element items.
     * 
     * @return list
     */
    public List<PriceQuoteDetailsHistoryInfo> getHistoryInfoList() {
        return historyInfoList;
    }

    /** 
     * Set the list of 'HistoryInfo' element items.
     * 
     * @param list
     */
    public void setHistoryInfoList(List<PriceQuoteDetailsHistoryInfo> list) {
        historyInfoList = list;
    }

    /** 
     * Get the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQ - Price Quote Record
    				PQR - Price Quote Reissue
    			
     * 
     * @return value
     */
    public CodePQType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQ - Price Quote Record
    				PQR - Price Quote Reissue
    			
     * 
     * @param type
     */
    public void setType(CodePQType type) {
        this.type = type;
    }

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
    				Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
     * 
     * @return value
     */
    public String getPassengerType() {
        return passengerType;
    }

    /** 
     * Set the 'passengerType' attribute value. Passenger type code this Price Quote is applicable to.
    				Ref: DM0Z_40_PTCD (airlines) / DM0Z_40_TPTC
     * 
     * @param passengerType
     */
    public void setPassengerType(String passengerType) {
        this.passengerType = passengerType;
    }

    /** 
     * Get the 'status' attribute value. PQ status
    				Possible values are:
    				A - Active
    				H - History
    				below values applicable only for airlines and not agencies
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value. PQ status
    				Possible values are:
    				A - Active
    				H - History
    				below values applicable only for airlines and not agencies
    				I - Inactive
    				M - Manual
    				X - Expired
    				U - Unretained
    				F - FSC Manual
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'pricingType' attribute value. Airlines/agencies
    				S - System
    				A - Ammended
    				M - Manual
     * 
     * @return value
     */
    public String getPricingType() {
        return pricingType;
    }

    /** 
     * Set the 'pricingType' attribute value. Airlines/agencies
    				S - System
    				A - Ammended
    				M - Manual
     * 
     * @param pricingType
     */
    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    /** 
     * Get the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

    				Possible values:

    				Abacus GDS
    				AUTO PRICED
    				MANUAL
    				RATE DESK

    				INFINI GDS
    				C-Guaranteed
    				W - With warning/Not guaranteed
    				M - amendments/Not guaranteed
    				A- overrides/Not guaranteed

    			
     * 
     * @return value
     */
    public String getPricingStatus() {
        return pricingStatus;
    }

    /** 
     * Set the 'pricingStatus' attribute value. Additional pricing status applicable for Abacus/Infini

    				Possible values:

    				Abacus GDS
    				AUTO PRICED
    				MANUAL
    				RATE DESK

    				INFINI GDS
    				C-Guaranteed
    				W - With warning/Not guaranteed
    				M - amendments/Not guaranteed
    				A- overrides/Not guaranteed

    			
     * 
     * @param pricingStatus
     */
    public void setPricingStatus(String pricingStatus) {
        this.pricingStatus = pricingStatus;
    }

    /** 
     * Get the 'displayOnly' attribute value. Set to true on PQ display only

    				Ref: DM0Z_85_BC35,#DM0Z_85_DOP
     * 
     * @return value
     */
    public Boolean getDisplayOnly() {
        return displayOnly;
    }

    /** 
     * Set the 'displayOnly' attribute value. Set to true on PQ display only

    				Ref: DM0Z_85_BC35,#DM0Z_85_DOP
     * 
     * @param displayOnly
     */
    public void setDisplayOnly(Boolean displayOnly) {
        this.displayOnly = displayOnly;
    }

    /** 
     * Get the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
    				Ref: #DM0Z_40_HCPQ
    				Value is false if attribute not present. 
     * 
     * @return value
     */
    public Boolean getLowCostCarrier() {
        return lowCostCarrier;
    }

    /** 
     * Set the 'lowCostCarrier' attribute value. PQ created to be ticketed by EasyJet, Instant Purchase Carrier (IPC), Low Cost Carrier (LCC) or Hybrid Carrier (HCPQ)
    				Ref: #DM0Z_40_HCPQ
    				Value is false if attribute not present. 
     * 
     * @param lowCostCarrier
     */
    public void setLowCostCarrier(Boolean lowCostCarrier) {
        this.lowCostCarrier = lowCostCarrier;
    }
}
