
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.SearchParameters">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CustomDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuoteInfo.SearchParameters" name="PriceQuoteInfo" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:String.ResultType" use="required" name="resultType"/>
 *   &lt;xs:attribute type="xs:boolean" name="stateful"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteSearchParameters implements Serializable
{
    private List<String> customDetailList = new ArrayList<String>();
    private List<PriceQuoteInfoSearchParameters> priceQuoteInfoList = new ArrayList<PriceQuoteInfoSearchParameters>();
    private StringResultType resultType;
    private Boolean stateful;

    /** 
     * Get the list of 'CustomDetails' element items. If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
    					element, each section as separate element.
    					Available sections are:
    			- NameAssociationInfo	- SegmentInfo			- FareInfo
    - AdditionalFareInfo
    - FeeInfo
    - MiscellaneousInfo
    - PaymentInfo
    - HistoryInfo
    - RefundInfo
    - ExchangeDocInfo
    - ResidualInfo
    - AddCollectInfo     
    - FareComparisonSummary  
     * 
     * @return list
     */
    public List<String> getCustomDetailList() {
        return customDetailList;
    }

    /** 
     * Set the list of 'CustomDetails' element items. If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
    					element, each section as separate element.
    					Available sections are:
    			- NameAssociationInfo	- SegmentInfo			- FareInfo
    - AdditionalFareInfo
    - FeeInfo
    - MiscellaneousInfo
    - PaymentInfo
    - HistoryInfo
    - RefundInfo
    - ExchangeDocInfo
    - ResidualInfo
    - AddCollectInfo     
    - FareComparisonSummary  
     * 
     * @param list
     */
    public void setCustomDetailList(List<String> list) {
        customDetailList = list;
    }

    /** 
     * Get the list of 'PriceQuoteInfo' element items. Price Quote information stored in single PNR
    					Ticketing System can get more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time and attempt to seach for Price Quotes in more than one PNR will result in error                    
     * 
     * @return list
     */
    public List<PriceQuoteInfoSearchParameters> getPriceQuoteInfoList() {
        return priceQuoteInfoList;
    }

    /** 
     * Set the list of 'PriceQuoteInfo' element items. Price Quote information stored in single PNR
    					Ticketing System can get more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time and attempt to seach for Price Quotes in more than one PNR will result in error                    
     * 
     * @param list
     */
    public void setPriceQuoteInfoList(List<PriceQuoteInfoSearchParameters> list) {
        priceQuoteInfoList = list;
    }

    /** 
     * Get the 'resultType' attribute value. A code that represents the format of response to be returned.

    				If resultType=D is specified (Detail), both Details and Name Association info will be returned in the response.

    				If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
    				element, each section as separate element.
    				Available sections are:
    				- NameAssociationInfo
    				- SegmentInfo
    				- FareInfo
    				- FeeInfo
    				- MiscellaneousInfo

    				If resultType=S is specified, only summary of PriceQuote and Name association/Unassociated will be returned in response

    				If resultType= B is specified, Active NameAssociated priceQuotes and summary breakdown of Pricequotes by passenger type will be returned in reponse(PQSB)

               If resultType=F is specified, only summary of PQF data will be returned in response	(PQF)			
     * 
     * @return value
     */
    public StringResultType getResultType() {
        return resultType;
    }

    /** 
     * Set the 'resultType' attribute value. A code that represents the format of response to be returned.

    				If resultType=D is specified (Detail), both Details and Name Association info will be returned in the response.

    				If @resultType=C attribute is specified (Custom), then requested data sections needs to be defined in this
    				element, each section as separate element.
    				Available sections are:
    				- NameAssociationInfo
    				- SegmentInfo
    				- FareInfo
    				- FeeInfo
    				- MiscellaneousInfo

    				If resultType=S is specified, only summary of PriceQuote and Name association/Unassociated will be returned in response

    				If resultType= B is specified, Active NameAssociated priceQuotes and summary breakdown of Pricequotes by passenger type will be returned in reponse(PQSB)

               If resultType=F is specified, only summary of PQF data will be returned in response	(PQF)			
     * 
     * @param resultType
     */
    public void setResultType(StringResultType resultType) {
        this.resultType = resultType;
    }

    /** 
     * Get the 'stateful' attribute value. This flag indicates if the request is stateful or stateless. If omitted, it will be defaulted to stateless request.
    				For stateful service, the Lniata under GetPriceQuoteRQ/POS/Lniata is mandatory.
    				For stateless service, the Reservation under GetPriceQuoteRQ/SearchParameters/PriceQuoteInfo/Reservation is mandatory.
    			
     * 
     * @return value
     */
    public Boolean getStateful() {
        return stateful;
    }

    /** 
     * Set the 'stateful' attribute value. This flag indicates if the request is stateful or stateless. If omitted, it will be defaulted to stateless request.
    				For stateful service, the Lniata under GetPriceQuoteRQ/POS/Lniata is mandatory.
    				For stateless service, the Reservation under GetPriceQuoteRQ/SearchParameters/PriceQuoteInfo/Reservation is mandatory.
    			
     * 
     * @param stateful
     */
    public void setStateful(Boolean stateful) {
        this.stateful = stateful;
    }
}
