
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Summary.SummaryByPassengerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PriceQuote.Summary.FareByPassenger" name="FareInfo" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceQuote.CommonFare" name="Total" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteSummarySummaryByPassengerType implements Serializable
{
    private List<PriceQuoteSummaryFareByPassenger> fareInfoList = new ArrayList<PriceQuoteSummaryFareByPassenger>();
    private List<PriceQuoteCommonFare> totalList = new ArrayList<PriceQuoteCommonFare>();

    /** 
     * Get the list of 'FareInfo' element items. Fare details in the PriceQuote
     * 
     * @return list
     */
    public List<PriceQuoteSummaryFareByPassenger> getFareInfoList() {
        return fareInfoList;
    }

    /** 
     * Set the list of 'FareInfo' element items. Fare details in the PriceQuote
     * 
     * @param list
     */
    public void setFareInfoList(List<PriceQuoteSummaryFareByPassenger> list) {
        fareInfoList = list;
    }

    /** 
     * Get the list of 'Total' element items. Sum of price quote fares for all passenger types
     * 
     * @return list
     */
    public List<PriceQuoteCommonFare> getTotalList() {
        return totalList;
    }

    /** 
     * Set the list of 'Total' element items. Sum of price quote fares for all passenger types
     * 
     * @param list
     */
    public void setTotalList(List<PriceQuoteCommonFare> list) {
        totalList = list;
    }
}
