
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Update.BaggageDisclosureAttributes">
 *   &lt;xs:attribute type="ns:Update.BaggageDisclosure.action" use="required" name="action"/>
 *   &lt;xs:attribute type="xs:string" name="disclosureType"/>
 *   &lt;xs:attribute type="xs:string" name="allowance"/>
 *   &lt;xs:attribute type="ns:Code.BaggageType.List" name="type"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PriceQuoteUpdateBaggageDisclosureAttributes implements
    Serializable
{
    private UpdateBaggageDisclosureAction action;
    private String disclosureType;
    private String allowance;
    private CodeBaggageTypeList type;

    /** 
     * Get the 'action' attribute value. Action to be performed on the selected PQ for Baggage disclosure update
    				Possible values - U for update/add and D for delete.
    			
     * 
     * @return value
     */
    public UpdateBaggageDisclosureAction getAction() {
        return action;
    }

    /** 
     * Set the 'action' attribute value. Action to be performed on the selected PQ for Baggage disclosure update
    				Possible values - U for update/add and D for delete.
    			
     * 
     * @param action
     */
    public void setAction(UpdateBaggageDisclosureAction action) {
        this.action = action;
    }

    /** 
     * Get the 'disclosureType' attribute value. Type of disclosure.
    				Possible type of baggage - A, B, C, D, E, P
    				Ref: DM0Z_60_TYPB
    			
     * 
     * @return value
     */
    public String getDisclosureType() {
        return disclosureType;
    }

    /** 
     * Set the 'disclosureType' attribute value. Type of disclosure.
    				Possible type of baggage - A, B, C, D, E, P
    				Ref: DM0Z_60_TYPB
    			
     * 
     * @param disclosureType
     */
    public void setDisclosureType(String disclosureType) {
        this.disclosureType = disclosureType;
    }

    /** 
     * Get the 'allowance' attribute value. Number/Weight of bag(s). Applicable for disclosure type 'E'.
    				Ref: DM0Z_70_BAMT
     * 
     * @return value
     */
    public String getAllowance() {
        return allowance;
    }

    /** 
     * Set the 'allowance' attribute value. Number/Weight of bag(s). Applicable for disclosure type 'E'.
    				Ref: DM0Z_70_BAMT
     * 
     * @param allowance
     */
    public void setAllowance(String allowance) {
        this.allowance = allowance;
    }

    /** 
     * Get the 'type' attribute value. Baggage type. Applicable for disclosure type 'E'.
    				Possible values: P - pieces, K - Kilos, L - Pounds, N - NIL
    				Ref: DM0Z_70_BTYP
     * 
     * @return value
     */
    public CodeBaggageTypeList getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Baggage type. Applicable for disclosure type 'E'.
    				Possible values: P - pieces, K - Kilos, L - Pounds, N - NIL
    				Ref: DM0Z_70_BTYP
     * 
     * @param type
     */
    public void setType(CodeBaggageTypeList type) {
        this.type = type;
    }
}
