
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote.Update.PQNumber">
 *   &lt;xs:attribute type="xs:anySimpleType" use="required" name="number"/>
 *   &lt;xs:attribute type="xs:integer" name="endNumber"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteUpdatePQNumber implements Serializable
{
    private String number;
    private BigInteger endNumber;
    private String type;

    /** 
     * Get the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'number' attribute value. PQ sequence number as stored and displayed from the database
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'endNumber' attribute value. PQ end number for range
     * 
     * @return value
     */
    public BigInteger getEndNumber() {
        return endNumber;
    }

    /** 
     * Set the 'endNumber' attribute value. PQ end number for range
     * 
     * @param endNumber
     */
    public void setEndNumber(BigInteger endNumber) {
        this.endNumber = endNumber;
    }

    /** 
     * Get the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQR - Price Quote Record
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Price Quote Type

    				Possible values can be:
    				PQR - Price Quote Record
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
}
