
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundFare.CommissionDetails">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="source"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RefundFareCommissionDetails implements Serializable
{
    private Amount amount;
    private BigDecimal percentage;
    private String source;
    private String type;

    /** 
     * Get the 'Amount' element value. Commision amount/penalty
    					Ref: DM0Z_85_COMA
    				
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Commision amount/penalty
    					Ref: DM0Z_85_COMA
    				
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Percentage' element value. Commision percentage
    					Ref: DM0Z_85_KXPA
    				
     * 
     * @return value
     */
    public BigDecimal getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Commision percentage
    					Ref: DM0Z_85_KXPA
    				
     * 
     * @param percentage
     */
    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    /** 
     * Get the 'source' attribute value. AGT - Agent-entered Commission
    			
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'source' attribute value. AGT - Agent-entered Commission
    			
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the 'type' attribute value. Possible values:    'Penalty'				'NET'				'Refund'
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. Possible values:    'Penalty'				'NET'				'Refund'
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
}
