
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReservationDetails.Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketInstructions" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="FutureProcessingLine" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PassengerAccountCode" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReservationDetailsType implements Serializable
{
    private List<String> ticketInstructionList = new ArrayList<String>();
    private List<String> futureProcessingLineList = new ArrayList<String>();
    private List<String> passengerAccountCodeList = new ArrayList<String>();

    /** 
     * Get the list of 'TicketInstructions' element items. Includes the ticketing instruction

    					Ref: PR00_96_ITD_DATA
     * 
     * @return list
     */
    public List<String> getTicketInstructionList() {
        return ticketInstructionList;
    }

    /** 
     * Set the list of 'TicketInstructions' element items. Includes the ticketing instruction

    					Ref: PR00_96_ITD_DATA
     * 
     * @param list
     */
    public void setTicketInstructionList(List<String> list) {
        ticketInstructionList = list;
    }

    /** 
     * Get the list of 'FutureProcessingLine' element items. Used for Future Pricing

    					Ref: PR00_A4_FTP_DATA
     * 
     * @return list
     */
    public List<String> getFutureProcessingLineList() {
        return futureProcessingLineList;
    }

    /** 
     * Set the list of 'FutureProcessingLine' element items. Used for Future Pricing

    					Ref: PR00_A4_FTP_DATA
     * 
     * @param list
     */
    public void setFutureProcessingLineList(List<String> list) {
        futureProcessingLineList = list;
    }

    /** 
     * Get the list of 'PassengerAccountCode' element items. Airline AccountingCode associated to PNR

    					Ref: PR00_98_ACC_DATA
     * 
     * @return list
     */
    public List<String> getPassengerAccountCodeList() {
        return passengerAccountCodeList;
    }

    /** 
     * Set the list of 'PassengerAccountCode' element items. Airline AccountingCode associated to PNR

    					Ref: PR00_98_ACC_DATA
     * 
     * @param list
     */
    public void setPassengerAccountCodeList(List<String> list) {
        passengerAccountCodeList = list;
    }
}
