
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment.FlightData">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Identifier.Flight" name="MarketingFlight" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="ns:Details.OrigDest" name="Departure" minOccurs="0"/>
 *     &lt;xs:element type="ns:Details.OrigDest" name="Arrival" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="connectionIndicator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SegmentFlightData implements Serializable
{
    private IdentifierFlight marketingFlight;
    private String classOfService;
    private DetailsOrigDest departure;
    private DetailsOrigDest arrival;
    private String connectionIndicator;

    /** 
     * Get the 'MarketingFlight' element value. Marketing Flight Info

    					Carrier Code
    					Ref: DM0Z_70_CXRM
    					Flight number
    					Ref: DM0Z_70_FLTM
    					Carrier name DM0Z_70_CXNM
     * 
     * @return value
     */
    public IdentifierFlight getMarketingFlight() {
        return marketingFlight;
    }

    /** 
     * Set the 'MarketingFlight' element value. Marketing Flight Info

    					Carrier Code
    					Ref: DM0Z_70_CXRM
    					Flight number
    					Ref: DM0Z_70_FLTM
    					Carrier name DM0Z_70_CXNM
     * 
     * @param marketingFlight
     */
    public void setMarketingFlight(IdentifierFlight marketingFlight) {
        this.marketingFlight = marketingFlight;
    }

    /** 
     * Get the 'ClassOfService' element value. Booking class of service
    					Ref: DM0Z_70_CLSP
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Booking class of service
    					Ref: DM0Z_70_CLSP
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'Departure' element value. Departure Info

    					Departure DateTime
    					Ref: DM0Z_70_FDDB
    					Ref:DM0Z_70_FDTB
    					Departure CityCode
    					Ref: DM0Z_70_DCTY
    					Departure City name
    					Ref: DM0Z_70_DCTN
     * 
     * @return value
     */
    public DetailsOrigDest getDeparture() {
        return departure;
    }

    /** 
     * Set the 'Departure' element value. Departure Info

    					Departure DateTime
    					Ref: DM0Z_70_FDDB
    					Ref:DM0Z_70_FDTB
    					Departure CityCode
    					Ref: DM0Z_70_DCTY
    					Departure City name
    					Ref: DM0Z_70_DCTN
     * 
     * @param departure
     */
    public void setDeparture(DetailsOrigDest departure) {
        this.departure = departure;
    }

    /** 
     * Get the 'Arrival' element value. Arrival Info

    					Arrival DateTime
    					Ref: DM0Z_70_FADB
    					Ref:DM0Z_70_FATB
    					Arrival CityCode
    					Ref: DM0Z_70_ACTY
    					Arrival City name
    					Ref:DM0Z_70_ACTN
     * 
     * @return value
     */
    public DetailsOrigDest getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value. Arrival Info

    					Arrival DateTime
    					Ref: DM0Z_70_FADB
    					Ref:DM0Z_70_FATB
    					Arrival CityCode
    					Ref: DM0Z_70_ACTY
    					Arrival City name
    					Ref:DM0Z_70_ACTN
     * 
     * @param arrival
     */
    public void setArrival(DetailsOrigDest arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
    				Ref: DM0Z_70_DCON. Possible values:
    				X = Transit
    				O = Stopover 
     * 
     * @return value
     */
    public String getConnectionIndicator() {
        return connectionIndicator;
    }

    /** 
     * Set the 'connectionIndicator' attribute value. Denotes if the connection is a stopover or a transit
    				Ref: DM0Z_70_DCON. Possible values:
    				X = Transit
    				O = Stopover 
     * 
     * @param connectionIndicator
     */
    public void setConnectionIndicator(String connectionIndicator) {
        this.connectionIndicator = connectionIndicator;
    }
}
