
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelItinerary.Search">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="NameNumber" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:SearchOn.Itinerary" name="Segment" maxOccurs="30"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelItinerarySearch implements Serializable
{
    private List<String> nameNumberList = new ArrayList<String>();
    private List<SearchOnItinerary> segmentList = new ArrayList<SearchOnItinerary>();

    /** 
     * Get the list of 'NameNumber' element items. A sequence number of the customer name as it is stored in the reservation record.
     * 
     * @return list
     */
    public List<String> getNameNumberList() {
        return nameNumberList;
    }

    /** 
     * Set the list of 'NameNumber' element items. A sequence number of the customer name as it is stored in the reservation record.
     * 
     * @param list
     */
    public void setNameNumberList(List<String> list) {
        nameNumberList = list;
    }

    /** 
     * Get the list of 'Segment' element items. repeats on the number of itinerary segments
     * 
     * @return list
     */
    public List<SearchOnItinerary> getSegmentList() {
        return segmentList;
    }

    /** 
     * Set the list of 'Segment' element items. repeats on the number of itinerary segments
     * 
     * @param list
     */
    public void setSegmentList(List<SearchOnItinerary> list) {
        segmentList = list;
    }
}
