
package com.sabre.ns.ticketing.pqs;

import com.sabre.ns.ticketing.ttl.HeaderRS;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdatePriceQuoteRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:Header.RS" name="Header"/>
 *     &lt;xs:element type="ns:PriceQuoteInfo.Update.Response" name="PriceQuoteInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PriceQuoteStdAttributes"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteStdAttributes">
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class UpdatePriceQuoteRS implements Serializable
{
    private HeaderRS header;
    private List<PriceQuoteInfoUpdateResponse> priceQuoteInfoList = new ArrayList<PriceQuoteInfoUpdateResponse>();
    private List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
    private String version;

    /** 
     * Get the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @return value
     */
    public HeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Standard header information that help orchestrate the requests
     * 
     * @param header
     */
    public void setHeader(HeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the list of 'PriceQuoteInfo' element items. Price Quote information stored in single PNR

    					Ticketing System can update more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time
    					and attempt to update Price Quotes in more than one PNR will result in error
    				
     * 
     * @return list
     */
    public List<PriceQuoteInfoUpdateResponse> getPriceQuoteInfoList() {
        return priceQuoteInfoList;
    }

    /** 
     * Set the list of 'PriceQuoteInfo' element items. Price Quote information stored in single PNR

    					Ticketing System can update more than one PNR per transaction. For the initial implementation the maximum is one PNR at a time
    					and attempt to update Price Quotes in more than one PNR will result in error
    				
     * 
     * @param list
     */
    public void setPriceQuoteInfoList(List<PriceQuoteInfoUpdateResponse> list) {
        priceQuoteInfoList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items.
     * 
     * @return list
     */
    public List<Diagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items.
     * 
     * @param list
     */
    public void setDiagnosticList(List<Diagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Version of the service the service consumer wishes to use.
    				NOTE: In order for SWSO to be able to capture the version of the service being used in their logs/statistics,
    				this attribute needs to be named Version (with a capital letter - which is against our naming convention).
    			
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Version of the service the service consumer wishes to use.
    				NOTE: In order for SWSO to be able to capture the version of the service being used in their logs/statistics,
    				this attribute needs to be named Version (with a capital letter - which is against our naming convention).
    			
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
