
package com.sabre.ns.ticketing.pqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateTypeChoice.CG">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PriceQuoteInfo.UpdateAssociation" name="UpdateNameAssociation" maxOccurs="99"/>
 *     &lt;xs:element type="ns:PriceQuote.UpdateParameters.PriceQuote" name="UpdateDetails" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class UpdateTypeChoiceCG implements Serializable
{
    private int choiceSelect = -1;
    private static final int UPDATE_NAME_ASSOCIATION_LIST_CHOICE = 0;
    private static final int UPDATE_DETAIL_LIST_CHOICE = 1;
    private List<PriceQuoteInfoUpdateAssociation> updateNameAssociationList = new ArrayList<PriceQuoteInfoUpdateAssociation>();
    private List<PriceQuoteUpdateParametersPriceQuote> updateDetailList = new ArrayList<PriceQuoteUpdateParametersPriceQuote>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if UpdateNameAssociationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUpdateNameAssociationList() {
        return choiceSelect == UPDATE_NAME_ASSOCIATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'UpdateNameAssociation' element items. This type of update can be used to modify passenger association to the Price Quote items. This element is
    					repeated for each passenger
    				
     * 
     * @return list
     */
    public List<PriceQuoteInfoUpdateAssociation> getUpdateNameAssociationList() {
        return updateNameAssociationList;
    }

    /** 
     * Set the list of 'UpdateNameAssociation' element items. This type of update can be used to modify passenger association to the Price Quote items. This element is
    					repeated for each passenger
    				
     * 
     * @param list
     */
    public void setUpdateNameAssociationList(
            List<PriceQuoteInfoUpdateAssociation> list) {
        setChoiceSelect(UPDATE_NAME_ASSOCIATION_LIST_CHOICE);
        updateNameAssociationList = list;
    }

    /** 
     * Check if UpdateDetailList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUpdateDetailList() {
        return choiceSelect == UPDATE_DETAIL_LIST_CHOICE;
    }

    /** 
     * Get the list of 'UpdateDetails' element items.
     * 
     * @return list
     */
    public List<PriceQuoteUpdateParametersPriceQuote> getUpdateDetailList() {
        return updateDetailList;
    }

    /** 
     * Set the list of 'UpdateDetails' element items.
     * 
     * @param list
     */
    public void setUpdateDetailList(
            List<PriceQuoteUpdateParametersPriceQuote> list) {
        setChoiceSelect(UPDATE_DETAIL_LIST_CHOICE);
        updateDetailList = list;
    }
}
