
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code.CategoryCode">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cash"/>
 *     &lt;xs:enumeration value="Credit"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CodeCategoryCode implements Serializable {
    CASH("Cash"), CREDIT("Credit");
    private final String value;

    private CodeCategoryCode(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CodeCategoryCode convert(String value) {
        for (CodeCategoryCode inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
