
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Code.OverShortCode">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="over"/>
 *     &lt;xs:enumeration value="short"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CodeOverShortCode implements Serializable {
    OVER("over"), SHORT("short");
    private final String value;

    private CodeOverShortCode(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CodeOverShortCode convert(String value) {
        for (CodeOverShortCode inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
