
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Error type codes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.ErrorType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Transport"/>
 *     &lt;xs:enumeration value="Validation"/>
 *     &lt;xs:enumeration value="Application"/>
 *     &lt;xs:enumeration value="BusinessLogic"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum HeaderErrorType implements Serializable {
    /** 
     * Transport errors occur when the infrastructure systems are unable to deliver the request message to the service provider or the service response is not delivered within the allotted time frame. These errors are always detected by the transport infrastructure systems. The detecting system should indicate the need for compensation in Severity and Status values. These errors may be transient and consumers may choose to retry their request.
     */
    TRANSPORT("Transport"), /** 
                             * Validation errors occur when the message is determined to not conform to the interface specifications.  For example, it is an validation error when the request violates security requirements or the message is not schema valid according to the service interface schema. These errors may be detected by either the transport or application systems.  Applications must not make changes that will require compensation when validation errors are detected. These errors are caused by the structure or content of the request and consumers should not attempt to retry their unmodified request.
                             */
    VALIDATION("Validation"), /** 
                               * Application errors occur when a valid message is delivered to the service provider yet the request cannot be completely processed. This can occur when the provider has technical issues such as internal exceptions, database locks, or connectivity failure to a system it is dependent upon. These errors are always detected by the application system. The application should indicate the need for compensation in Severity and Status values. These errors may be transient and consumers may choose to retry their request.
                               */
    APPLICATION("Application"), /** 
                                 * Business logic errors occur when a service provider is able to process the request message but the request violates pre-condition or internal application business logic.  Example business logic errors are a request for flight information but the flight does not exist or a request to reserve more seats than are on the aircraft. The response message will likely provide details about the error condition and may or may not use a standard error response record. Business logic errors are always detected by the application system. Applications must not make changes that will require compensation when business logic errors are detected. These errors are caused by content of the request; consumers should only attempt to retry their unmodified request if the business condition described in the application specific response indicates the condition may be transient. Service providers should use the ErrorMessage and code attribute to describe the business condition and document those conditions in their service contract.
                                 */
    BUSINESS_LOGIC("BusinessLogic");
    private final String value;

    private HeaderErrorType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static HeaderErrorType convert(String value) {
        for (HeaderErrorType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
