
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Result type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.ResultRecord">
 *   &lt;xs:sequence>
 *     &lt;xs:group ref="ns:Header.SuccessOrErrorCG"/>
 *     &lt;xs:element type="ns:Header.ProblemInformation" name="Warning" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HeaderResultRecord implements Serializable
{
    private HeaderSuccessOrErrorCG headerSuccessOrErrorCG;
    private List<HeaderProblemInformation> warningList = new ArrayList<HeaderProblemInformation>();

    /** 
     * Get the 'Header.SuccessOrErrorCG' group value.
     * 
     * @return value
     */
    public HeaderSuccessOrErrorCG getHeaderSuccessOrErrorCG() {
        return headerSuccessOrErrorCG;
    }

    /** 
     * Set the 'Header.SuccessOrErrorCG' group value.
     * 
     * @param headerSuccessOrErrorCG
     */
    public void setHeaderSuccessOrErrorCG(
            HeaderSuccessOrErrorCG headerSuccessOrErrorCG) {
        this.headerSuccessOrErrorCG = headerSuccessOrErrorCG;
    }

    /** 
     * Get the list of 'Warning' element items.
     * 
     * @return list
     */
    public List<HeaderProblemInformation> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items.
     * 
     * @param list
     */
    public void setWarningList(List<HeaderProblemInformation> list) {
        warningList = list;
    }
}
