
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Success or Error choice group
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.SuccessOrErrorCG">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:Header.Success" name="Success"/>
 *     &lt;xs:element type="ns:Header.ProblemInformation" name="Error"/>
 *   &lt;/xs:choice>
 * &lt;/xs:group>
 * </pre>
 */
public class HeaderSuccessOrErrorCG implements Serializable
{
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERROR_CHOICE = 1;
    private HeaderSuccess success;
    private HeaderProblemInformation error;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. Success is an empty element with no children which indicates that the request was processed successfully.
     * 
     * @return value
     */
    public HeaderSuccess getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. Success is an empty element with no children which indicates that the request was processed successfully.
     * 
     * @param success
     */
    public void setSuccess(HeaderSuccess success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Check if Error is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifError() {
        return choiceSelect == ERROR_CHOICE;
    }

    /** 
     * Get the 'Error' element value.
     * 
     * @return value
     */
    public HeaderProblemInformation getError() {
        return error;
    }

    /** 
     * Set the 'Error' element value.
     * 
     * @param error
     */
    public void setError(HeaderProblemInformation error) {
        setChoiceSelect(ERROR_CHOICE);
        this.error = error;
    }
}
