
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * System specific error information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Header.SystemSpecificResults">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Header.ErrorMessage" name="ErrorMessage" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Element" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RecordID" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HeaderSystemSpecificResults implements Serializable
{
    private HeaderErrorMessage errorMessage;
    private String shortText;
    private String element;
    private String recordID;

    /** 
     * Get the 'ErrorMessage' element value. Application specific Error code and Message. A textual description to provide more information about the specific error  with code attribute as numeric value.
     * 
     * @return value
     */
    public HeaderErrorMessage getErrorMessage() {
        return errorMessage;
    }

    /** 
     * Set the 'ErrorMessage' element value. Application specific Error code and Message. A textual description to provide more information about the specific error  with code attribute as numeric value.
     * 
     * @param errorMessage
     */
    public void setErrorMessage(HeaderErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
    }

    /** 
     * Get the 'ShortText' element value. An abbreviated version of the error in textual format.
     * 
     * @return value
     */
    public String getShortText() {
        return shortText;
    }

    /** 
     * Set the 'ShortText' element value. An abbreviated version of the error in textual format.
     * 
     * @param shortText
     */
    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    /** 
     * Get the 'Element' element value. If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * 
     * @return value
     */
    public String getElement() {
        return element;
    }

    /** 
     * Set the 'Element' element value. If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * 
     * @param element
     */
    public void setElement(String element) {
        this.element = element;
    }

    /** 
     * Get the 'RecordID' element value. If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s) associated with that transaction.
     * 
     * @return value
     */
    public String getRecordID() {
        return recordID;
    }

    /** 
     * Set the 'RecordID' element value. If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s) associated with that transaction.
     * 
     * @param recordID
     */
    public void setRecordID(String recordID) {
        this.recordID = recordID;
    }
}
