
package com.sabre.ns.ticketing.ttl;

import java.io.Serializable;

/** 
 * Pricing Branded Fare section for brand components to be specified for pricing request. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Misc.BrandedFare">
 *   &lt;xs:attribute type="xs:anySimpleType" name="code"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="description"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="programCode"/>
 *   &lt;xs:attribute type="xs:anySimpleType" name="programDescription"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MiscBrandedFare implements Serializable
{
    private String code;
    private String description;
    private String programCode;
    private String programDescription;

    /** 
     * Get the 'code' attribute value. Pricing Brand Code to be specified for pricing request. The brand code can be minimum 2 characters and can go to a max of 10 characters.	84_BRCD as filed by pricing. Brand code can also come at the transaction level (25_BRCD) and at any point of time only one Brand Code should come in the request.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. Pricing Brand Code to be specified for pricing request. The brand code can be minimum 2 characters and can go to a max of 10 characters.	84_BRCD as filed by pricing. Brand code can also come at the transaction level (25_BRCD) and at any point of time only one Brand Code should come in the request.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'description' attribute value. Brand Description; max 30 chars; 84_BRNM
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'description' attribute value. Brand Description; max 30 chars; 84_BRNM
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'programCode' attribute value. Program Code; max 10 chars; 84_PRGM
     * 
     * @return value
     */
    public String getProgramCode() {
        return programCode;
    }

    /** 
     * Set the 'programCode' attribute value. Program Code; max 10 chars; 84_PRGM
     * 
     * @param programCode
     */
    public void setProgramCode(String programCode) {
        this.programCode = programCode;
    }

    /** 
     * Get the 'programDescription' attribute value. Program Description; max 30 chars; 84_PRNM
     * 
     * @return value
     */
    public String getProgramDescription() {
        return programDescription;
    }

    /** 
     * Set the 'programDescription' attribute value. Program Description; max 30 chars; 84_PRNM
     * 
     * @param programDescription
     */
    public void setProgramDescription(String programDescription) {
        this.programDescription = programDescription;
    }
}
