
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServicesDataGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NameAssociationList" name="NameAssociationList" minOccurs="0"/>
 *     &lt;xs:element type="ns:SegmentAssociationList" name="SegmentAssociationList" minOccurs="0"/>
 *     &lt;xs:group ref="ns:BasicAncillaryServicesDataGroup"/>
 *     &lt;xs:group ref="ns:OptionalAncillaryServicesInformationDataGroup"/>
 *     &lt;xs:element type="xs:integer" name="StatusIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NumberOfItems" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SegmentIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FrequentFlyerTier" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RefundFormIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareGuaranteedIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceChargeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AdvancePurchaseIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BookingSource" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TaxIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketingIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FeeWaiveReason" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FulfillmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AaPayOriginalSeat" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PdcSeat" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EquipmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AaPayOptionalStatus" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FirstTravelDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LastTravelDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="TTYConfirmationTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="PurchaseTimestamp" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BrandedFareId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GroupCode"/>
 *     &lt;xs:element type="xs:string" name="TourCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EmdPaperIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SeatRequestTransactionID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketUsedForEMDPricing" minOccurs="0"/>
 *     &lt;xs:element type="ns:Indicator" name="TaxExemption" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="PriceQuoteDesignator" minOccurs="0"/>
 *     &lt;xs:element type="ns:PriceMismatchAction" name="PriceMismatchAction" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InventoryControlledIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="InventoryConfirmationToken" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="ACSCount" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPrice" name="NetAmount" minOccurs="0"/>
 *     &lt;xs:element type="ns:AncillaryPriceQuoteData" name="AncillaryPriceQuoteData" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:SegmentOrTravelPortion" name="Segment" minOccurs="0"/>
 *       &lt;xs:element name="TravelPortions" minOccurs="0">
 *         &lt;!-- Reference to inner class TravelPortions -->
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class AncillaryServicesDataGroup implements Serializable
{
    private NameAssociationList nameAssociationList;
    private SegmentAssociationList segmentAssociationList;
    private BasicAncillaryServicesDataGroup basicAncillaryServicesDataGroup;
    private OptionalAncillaryServicesInformationDataGroup optionalAncillaryServicesInformationDataGroup;
    private BigInteger statusIndicator;
    private String numberOfItems;
    private String actionCode;
    private String segmentIndicator;
    private String frequentFlyerTier;
    private String refundFormIndicator;
    private String fareGuaranteedIndicator;
    private String serviceChargeIndicator;
    private String advancePurchaseIndicator;
    private String bookingSource;
    private String taxIndicator;
    private String ticketingIndicator;
    private String feeWaiveReason;
    private String fulfillmentType;
    private String aaPayOriginalSeat;
    private String pdcSeat;
    private String equipmentType;
    private String aaPayOptionalStatus;
    private String firstTravelDate;
    private String lastTravelDate;
    private Date TTYConfirmationTimestamp;
    private Date purchaseTimestamp;
    private String brandedFareId;
    private String groupCode;
    private String tourCode;
    private String emdPaperIndicator;
    private String seatRequestTransactionID;
    private String ticketUsedForEMDPricing;
    private Indicator taxExemption;
    private BigInteger priceQuoteDesignator;
    private PriceMismatchAction priceMismatchAction;
    private String inventoryControlledIndicator;
    private String inventoryConfirmationToken;
    private BigInteger ACSCount;
    private AncillaryPrice netAmount;
    private AncillaryPriceQuoteData ancillaryPriceQuoteData;
    private int choiceSelect = -1;
    private static final int SEGMENT_CHOICE = 0;
    private static final int TRAVEL_PORTIONS_CHOICE = 1;
    private SegmentOrTravelPortion segment;
    private TravelPortions travelPortions;

    /** 
     * Get the 'NameAssociationList' element value.
     * 
     * @return value
     */
    public NameAssociationList getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the 'NameAssociationList' element value.
     * 
     * @param nameAssociationList
     */
    public void setNameAssociationList(NameAssociationList nameAssociationList) {
        this.nameAssociationList = nameAssociationList;
    }

    /** 
     * Get the 'SegmentAssociationList' element value.
     * 
     * @return value
     */
    public SegmentAssociationList getSegmentAssociationList() {
        return segmentAssociationList;
    }

    /** 
     * Set the 'SegmentAssociationList' element value.
     * 
     * @param segmentAssociationList
     */
    public void setSegmentAssociationList(
            SegmentAssociationList segmentAssociationList) {
        this.segmentAssociationList = segmentAssociationList;
    }

    /** 
     * Get the 'BasicAncillaryServicesDataGroup' group value.
     * 
     * @return value
     */
    public BasicAncillaryServicesDataGroup getBasicAncillaryServicesDataGroup() {
        return basicAncillaryServicesDataGroup;
    }

    /** 
     * Set the 'BasicAncillaryServicesDataGroup' group value.
     * 
     * @param basicAncillaryServicesDataGroup
     */
    public void setBasicAncillaryServicesDataGroup(
            BasicAncillaryServicesDataGroup basicAncillaryServicesDataGroup) {
        this.basicAncillaryServicesDataGroup = basicAncillaryServicesDataGroup;
    }

    /** 
     * Get the 'OptionalAncillaryServicesInformationDataGroup' group value.
     * 
     * @return value
     */
    public OptionalAncillaryServicesInformationDataGroup getOptionalAncillaryServicesInformationDataGroup() {
        return optionalAncillaryServicesInformationDataGroup;
    }

    /** 
     * Set the 'OptionalAncillaryServicesInformationDataGroup' group value.
     * 
     * @param optionalAncillaryServicesInformationDataGroup
     */
    public void setOptionalAncillaryServicesInformationDataGroup(
            OptionalAncillaryServicesInformationDataGroup optionalAncillaryServicesInformationDataGroup) {
        this.optionalAncillaryServicesInformationDataGroup = optionalAncillaryServicesInformationDataGroup;
    }

    /** 
     * Get the 'StatusIndicator' element value.
     * 
     * @return value
     */
    public BigInteger getStatusIndicator() {
        return statusIndicator;
    }

    /** 
     * Set the 'StatusIndicator' element value.
     * 
     * @param statusIndicator
     */
    public void setStatusIndicator(BigInteger statusIndicator) {
        this.statusIndicator = statusIndicator;
    }

    /** 
     * Get the 'NumberOfItems' element value.
     * 
     * @return value
     */
    public String getNumberOfItems() {
        return numberOfItems;
    }

    /** 
     * Set the 'NumberOfItems' element value.
     * 
     * @param numberOfItems
     */
    public void setNumberOfItems(String numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    /** 
     * Get the 'ActionCode' element value.
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value.
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'SegmentIndicator' element value.
     * 
     * @return value
     */
    public String getSegmentIndicator() {
        return segmentIndicator;
    }

    /** 
     * Set the 'SegmentIndicator' element value.
     * 
     * @param segmentIndicator
     */
    public void setSegmentIndicator(String segmentIndicator) {
        this.segmentIndicator = segmentIndicator;
    }

    /** 
     * Get the 'FrequentFlyerTier' element value.
     * 
     * @return value
     */
    public String getFrequentFlyerTier() {
        return frequentFlyerTier;
    }

    /** 
     * Set the 'FrequentFlyerTier' element value.
     * 
     * @param frequentFlyerTier
     */
    public void setFrequentFlyerTier(String frequentFlyerTier) {
        this.frequentFlyerTier = frequentFlyerTier;
    }

    /** 
     * Get the 'RefundFormIndicator' element value.
     * 
     * @return value
     */
    public String getRefundFormIndicator() {
        return refundFormIndicator;
    }

    /** 
     * Set the 'RefundFormIndicator' element value.
     * 
     * @param refundFormIndicator
     */
    public void setRefundFormIndicator(String refundFormIndicator) {
        this.refundFormIndicator = refundFormIndicator;
    }

    /** 
     * Get the 'FareGuaranteedIndicator' element value.
     * 
     * @return value
     */
    public String getFareGuaranteedIndicator() {
        return fareGuaranteedIndicator;
    }

    /** 
     * Set the 'FareGuaranteedIndicator' element value.
     * 
     * @param fareGuaranteedIndicator
     */
    public void setFareGuaranteedIndicator(String fareGuaranteedIndicator) {
        this.fareGuaranteedIndicator = fareGuaranteedIndicator;
    }

    /** 
     * Get the 'ServiceChargeIndicator' element value.
     * 
     * @return value
     */
    public String getServiceChargeIndicator() {
        return serviceChargeIndicator;
    }

    /** 
     * Set the 'ServiceChargeIndicator' element value.
     * 
     * @param serviceChargeIndicator
     */
    public void setServiceChargeIndicator(String serviceChargeIndicator) {
        this.serviceChargeIndicator = serviceChargeIndicator;
    }

    /** 
     * Get the 'AdvancePurchaseIndicator' element value.
     * 
     * @return value
     */
    public String getAdvancePurchaseIndicator() {
        return advancePurchaseIndicator;
    }

    /** 
     * Set the 'AdvancePurchaseIndicator' element value.
     * 
     * @param advancePurchaseIndicator
     */
    public void setAdvancePurchaseIndicator(String advancePurchaseIndicator) {
        this.advancePurchaseIndicator = advancePurchaseIndicator;
    }

    /** 
     * Get the 'BookingSource' element value.
     * 
     * @return value
     */
    public String getBookingSource() {
        return bookingSource;
    }

    /** 
     * Set the 'BookingSource' element value.
     * 
     * @param bookingSource
     */
    public void setBookingSource(String bookingSource) {
        this.bookingSource = bookingSource;
    }

    /** 
     * Get the 'TaxIndicator' element value.
     * 
     * @return value
     */
    public String getTaxIndicator() {
        return taxIndicator;
    }

    /** 
     * Set the 'TaxIndicator' element value.
     * 
     * @param taxIndicator
     */
    public void setTaxIndicator(String taxIndicator) {
        this.taxIndicator = taxIndicator;
    }

    /** 
     * Get the 'TicketingIndicator' element value.
     * 
     * @return value
     */
    public String getTicketingIndicator() {
        return ticketingIndicator;
    }

    /** 
     * Set the 'TicketingIndicator' element value.
     * 
     * @param ticketingIndicator
     */
    public void setTicketingIndicator(String ticketingIndicator) {
        this.ticketingIndicator = ticketingIndicator;
    }

    /** 
     * Get the 'FeeWaiveReason' element value.
     * 
     * @return value
     */
    public String getFeeWaiveReason() {
        return feeWaiveReason;
    }

    /** 
     * Set the 'FeeWaiveReason' element value.
     * 
     * @param feeWaiveReason
     */
    public void setFeeWaiveReason(String feeWaiveReason) {
        this.feeWaiveReason = feeWaiveReason;
    }

    /** 
     * Get the 'FulfillmentType' element value.
     * 
     * @return value
     */
    public String getFulfillmentType() {
        return fulfillmentType;
    }

    /** 
     * Set the 'FulfillmentType' element value.
     * 
     * @param fulfillmentType
     */
    public void setFulfillmentType(String fulfillmentType) {
        this.fulfillmentType = fulfillmentType;
    }

    /** 
     * Get the 'AaPayOriginalSeat' element value.
     * 
     * @return value
     */
    public String getAaPayOriginalSeat() {
        return aaPayOriginalSeat;
    }

    /** 
     * Set the 'AaPayOriginalSeat' element value.
     * 
     * @param aaPayOriginalSeat
     */
    public void setAaPayOriginalSeat(String aaPayOriginalSeat) {
        this.aaPayOriginalSeat = aaPayOriginalSeat;
    }

    /** 
     * Get the 'PdcSeat' element value.
     * 
     * @return value
     */
    public String getPdcSeat() {
        return pdcSeat;
    }

    /** 
     * Set the 'PdcSeat' element value.
     * 
     * @param pdcSeat
     */
    public void setPdcSeat(String pdcSeat) {
        this.pdcSeat = pdcSeat;
    }

    /** 
     * Get the 'EquipmentType' element value.
     * 
     * @return value
     */
    public String getEquipmentType() {
        return equipmentType;
    }

    /** 
     * Set the 'EquipmentType' element value.
     * 
     * @param equipmentType
     */
    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    /** 
     * Get the 'AaPayOptionalStatus' element value.
     * 
     * @return value
     */
    public String getAaPayOptionalStatus() {
        return aaPayOptionalStatus;
    }

    /** 
     * Set the 'AaPayOptionalStatus' element value.
     * 
     * @param aaPayOptionalStatus
     */
    public void setAaPayOptionalStatus(String aaPayOptionalStatus) {
        this.aaPayOptionalStatus = aaPayOptionalStatus;
    }

    /** 
     * Get the 'FirstTravelDate' element value.
     * 
     * @return value
     */
    public String getFirstTravelDate() {
        return firstTravelDate;
    }

    /** 
     * Set the 'FirstTravelDate' element value.
     * 
     * @param firstTravelDate
     */
    public void setFirstTravelDate(String firstTravelDate) {
        this.firstTravelDate = firstTravelDate;
    }

    /** 
     * Get the 'LastTravelDate' element value.
     * 
     * @return value
     */
    public String getLastTravelDate() {
        return lastTravelDate;
    }

    /** 
     * Set the 'LastTravelDate' element value.
     * 
     * @param lastTravelDate
     */
    public void setLastTravelDate(String lastTravelDate) {
        this.lastTravelDate = lastTravelDate;
    }

    /** 
     * Get the 'TTYConfirmationTimestamp' element value.
     * 
     * @return value
     */
    public Date getTTYConfirmationTimestamp() {
        return TTYConfirmationTimestamp;
    }

    /** 
     * Set the 'TTYConfirmationTimestamp' element value.
     * 
     * @param TTYConfirmationTimestamp
     */
    public void setTTYConfirmationTimestamp(Date TTYConfirmationTimestamp) {
        this.TTYConfirmationTimestamp = TTYConfirmationTimestamp;
    }

    /** 
     * Get the 'PurchaseTimestamp' element value.
     * 
     * @return value
     */
    public Date getPurchaseTimestamp() {
        return purchaseTimestamp;
    }

    /** 
     * Set the 'PurchaseTimestamp' element value.
     * 
     * @param purchaseTimestamp
     */
    public void setPurchaseTimestamp(Date purchaseTimestamp) {
        this.purchaseTimestamp = purchaseTimestamp;
    }

    /** 
     * Get the 'BrandedFareId' element value.
     * 
     * @return value
     */
    public String getBrandedFareId() {
        return brandedFareId;
    }

    /** 
     * Set the 'BrandedFareId' element value.
     * 
     * @param brandedFareId
     */
    public void setBrandedFareId(String brandedFareId) {
        this.brandedFareId = brandedFareId;
    }

    /** 
     * Get the 'GroupCode' element value.
     * 
     * @return value
     */
    public String getGroupCode() {
        return groupCode;
    }

    /** 
     * Set the 'GroupCode' element value.
     * 
     * @param groupCode
     */
    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    /** 
     * Get the 'TourCode' element value.
     * 
     * @return value
     */
    public String getTourCode() {
        return tourCode;
    }

    /** 
     * Set the 'TourCode' element value.
     * 
     * @param tourCode
     */
    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    /** 
     * Get the 'EmdPaperIndicator' element value.
     * 
     * @return value
     */
    public String getEmdPaperIndicator() {
        return emdPaperIndicator;
    }

    /** 
     * Set the 'EmdPaperIndicator' element value.
     * 
     * @param emdPaperIndicator
     */
    public void setEmdPaperIndicator(String emdPaperIndicator) {
        this.emdPaperIndicator = emdPaperIndicator;
    }

    /** 
     * Get the 'SeatRequestTransactionID' element value.
     * 
     * @return value
     */
    public String getSeatRequestTransactionID() {
        return seatRequestTransactionID;
    }

    /** 
     * Set the 'SeatRequestTransactionID' element value.
     * 
     * @param seatRequestTransactionID
     */
    public void setSeatRequestTransactionID(String seatRequestTransactionID) {
        this.seatRequestTransactionID = seatRequestTransactionID;
    }

    /** 
     * Get the 'TicketUsedForEMDPricing' element value.
     * 
     * @return value
     */
    public String getTicketUsedForEMDPricing() {
        return ticketUsedForEMDPricing;
    }

    /** 
     * Set the 'TicketUsedForEMDPricing' element value.
     * 
     * @param ticketUsedForEMDPricing
     */
    public void setTicketUsedForEMDPricing(String ticketUsedForEMDPricing) {
        this.ticketUsedForEMDPricing = ticketUsedForEMDPricing;
    }

    /** 
     * Get the 'TaxExemption' element value.
     * 
     * @return value
     */
    public Indicator getTaxExemption() {
        return taxExemption;
    }

    /** 
     * Set the 'TaxExemption' element value.
     * 
     * @param taxExemption
     */
    public void setTaxExemption(Indicator taxExemption) {
        this.taxExemption = taxExemption;
    }

    /** 
     * Get the 'PriceQuoteDesignator' element value.
     * 
     * @return value
     */
    public BigInteger getPriceQuoteDesignator() {
        return priceQuoteDesignator;
    }

    /** 
     * Set the 'PriceQuoteDesignator' element value.
     * 
     * @param priceQuoteDesignator
     */
    public void setPriceQuoteDesignator(BigInteger priceQuoteDesignator) {
        this.priceQuoteDesignator = priceQuoteDesignator;
    }

    /** 
     * Get the 'PriceMismatchAction' element value.
     * 
     * @return value
     */
    public PriceMismatchAction getPriceMismatchAction() {
        return priceMismatchAction;
    }

    /** 
     * Set the 'PriceMismatchAction' element value.
     * 
     * @param priceMismatchAction
     */
    public void setPriceMismatchAction(PriceMismatchAction priceMismatchAction) {
        this.priceMismatchAction = priceMismatchAction;
    }

    /** 
     * Get the 'InventoryControlledIndicator' element value.
     * 
     * @return value
     */
    public String getInventoryControlledIndicator() {
        return inventoryControlledIndicator;
    }

    /** 
     * Set the 'InventoryControlledIndicator' element value.
     * 
     * @param inventoryControlledIndicator
     */
    public void setInventoryControlledIndicator(
            String inventoryControlledIndicator) {
        this.inventoryControlledIndicator = inventoryControlledIndicator;
    }

    /** 
     * Get the 'InventoryConfirmationToken' element value.
     * 
     * @return value
     */
    public String getInventoryConfirmationToken() {
        return inventoryConfirmationToken;
    }

    /** 
     * Set the 'InventoryConfirmationToken' element value.
     * 
     * @param inventoryConfirmationToken
     */
    public void setInventoryConfirmationToken(String inventoryConfirmationToken) {
        this.inventoryConfirmationToken = inventoryConfirmationToken;
    }

    /** 
     * Get the 'ACSCount' element value.
     * 
     * @return value
     */
    public BigInteger getACSCount() {
        return ACSCount;
    }

    /** 
     * Set the 'ACSCount' element value.
     * 
     * @param ACSCount
     */
    public void setACSCount(BigInteger ACSCount) {
        this.ACSCount = ACSCount;
    }

    /** 
     * Get the 'NetAmount' element value. Net Remit Payment amount, EX “250”
     * 
     * @return value
     */
    public AncillaryPrice getNetAmount() {
        return netAmount;
    }

    /** 
     * Set the 'NetAmount' element value. Net Remit Payment amount, EX “250”
     * 
     * @param netAmount
     */
    public void setNetAmount(AncillaryPrice netAmount) {
        this.netAmount = netAmount;
    }

    /** 
     * Get the 'AncillaryPriceQuoteData' element value.
     * 
     * @return value
     */
    public AncillaryPriceQuoteData getAncillaryPriceQuoteData() {
        return ancillaryPriceQuoteData;
    }

    /** 
     * Set the 'AncillaryPriceQuoteData' element value.
     * 
     * @param ancillaryPriceQuoteData
     */
    public void setAncillaryPriceQuoteData(
            AncillaryPriceQuoteData ancillaryPriceQuoteData) {
        this.ancillaryPriceQuoteData = ancillaryPriceQuoteData;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Segment is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSegment() {
        return choiceSelect == SEGMENT_CHOICE;
    }

    /** 
     * Get the 'Segment' element value.
     * 
     * @return value
     */
    public SegmentOrTravelPortion getSegment() {
        return segment;
    }

    /** 
     * Set the 'Segment' element value.
     * 
     * @param segment
     */
    public void setSegment(SegmentOrTravelPortion segment) {
        setChoiceSelect(SEGMENT_CHOICE);
        this.segment = segment;
    }

    /** 
     * Check if TravelPortions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelPortions() {
        return choiceSelect == TRAVEL_PORTIONS_CHOICE;
    }

    /** 
     * Get the 'TravelPortions' element value.
     * 
     * @return value
     */
    public TravelPortions getTravelPortions() {
        return travelPortions;
    }

    /** 
     * Set the 'TravelPortions' element value.
     * 
     * @param travelPortions
     */
    public void setTravelPortions(TravelPortions travelPortions) {
        setChoiceSelect(TRAVEL_PORTIONS_CHOICE);
        this.travelPortions = travelPortions;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPortions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:SegmentOrTravelPortion" name="TravelPortion" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelPortions implements Serializable
    {
        private List<SegmentOrTravelPortion> travelPortionList = new ArrayList<SegmentOrTravelPortion>();

        /** 
         * Get the list of 'TravelPortion' element items.
         * 
         * @return list
         */
        public List<SegmentOrTravelPortion> getTravelPortionList() {
            return travelPortionList;
        }

        /** 
         * Set the list of 'TravelPortion' element items.
         * 
         * @param list
         */
        public void setTravelPortionList(List<SegmentOrTravelPortion> list) {
            travelPortionList = list;
        }
    }
}
