
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormOfPayment">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:PaymentCard" name="PaymentCard" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:Cash" name="Cash" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:Check" name="Check" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:Invoice" name="Invoice" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:Docket" name="Docket" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:GTR" name="GTR" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:VirtualCard" name="VirtualCard" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:OtherFOP" name="Other" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:PayLaterPlan" name="PayLaterPlan" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:LoyaltyProgramRedemption" name="LoyaltyProgramRedemption" minOccurs="0" maxOccurs="1"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="miscFOP"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="migrated"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FormOfPayment implements Serializable
{
    private int choiceSelect = -1;
    private static final int PAYMENT_CARD_CHOICE = 0;
    private static final int CASH_CHOICE = 1;
    private static final int CHECK_CHOICE = 2;
    private static final int INVOICE_CHOICE = 3;
    private static final int DOCKET_CHOICE = 4;
    private static final int GTR_CHOICE = 5;
    private static final int VIRTUAL_CARD_CHOICE = 6;
    private static final int OTHER_CHOICE = 7;
    private static final int PAY_LATER_PLAN_CHOICE = 8;
    private static final int LOYALTY_PROGRAM_REDEMPTION_CHOICE = 9;
    private PaymentCard paymentCard;
    private Cash cash;
    private Check check;
    private Invoice invoice;
    private Docket docket;
    private GTR GTR;
    private VirtualCard virtualCard;
    private OtherFOP other;
    private PayLaterPlan payLaterPlan;
    private LoyaltyProgramRedemption loyaltyProgramRedemption;
    private Boolean miscFOP;
    private Boolean migrated;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PaymentCard is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentCard() {
        return choiceSelect == PAYMENT_CARD_CHOICE;
    }

    /** 
     * Get the 'PaymentCard' element value.
     * 
     * @return value
     */
    public PaymentCard getPaymentCard() {
        return paymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value.
     * 
     * @param paymentCard
     */
    public void setPaymentCard(PaymentCard paymentCard) {
        setChoiceSelect(PAYMENT_CARD_CHOICE);
        this.paymentCard = paymentCard;
    }

    /** 
     * Check if Cash is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCash() {
        return choiceSelect == CASH_CHOICE;
    }

    /** 
     * Get the 'Cash' element value.
     * 
     * @return value
     */
    public Cash getCash() {
        return cash;
    }

    /** 
     * Set the 'Cash' element value.
     * 
     * @param cash
     */
    public void setCash(Cash cash) {
        setChoiceSelect(CASH_CHOICE);
        this.cash = cash;
    }

    /** 
     * Check if Check is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCheck() {
        return choiceSelect == CHECK_CHOICE;
    }

    /** 
     * Get the 'Check' element value.
     * 
     * @return value
     */
    public Check getCheck() {
        return check;
    }

    /** 
     * Set the 'Check' element value.
     * 
     * @param check
     */
    public void setCheck(Check check) {
        setChoiceSelect(CHECK_CHOICE);
        this.check = check;
    }

    /** 
     * Check if Invoice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifInvoice() {
        return choiceSelect == INVOICE_CHOICE;
    }

    /** 
     * Get the 'Invoice' element value.
     * 
     * @return value
     */
    public Invoice getInvoice() {
        return invoice;
    }

    /** 
     * Set the 'Invoice' element value.
     * 
     * @param invoice
     */
    public void setInvoice(Invoice invoice) {
        setChoiceSelect(INVOICE_CHOICE);
        this.invoice = invoice;
    }

    /** 
     * Check if Docket is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocket() {
        return choiceSelect == DOCKET_CHOICE;
    }

    /** 
     * Get the 'Docket' element value.
     * 
     * @return value
     */
    public Docket getDocket() {
        return docket;
    }

    /** 
     * Set the 'Docket' element value.
     * 
     * @param docket
     */
    public void setDocket(Docket docket) {
        setChoiceSelect(DOCKET_CHOICE);
        this.docket = docket;
    }

    /** 
     * Check if GTR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGTR() {
        return choiceSelect == GTR_CHOICE;
    }

    /** 
     * Get the 'GTR' element value.
     * 
     * @return value
     */
    public GTR getGTR() {
        return GTR;
    }

    /** 
     * Set the 'GTR' element value.
     * 
     * @param GTR
     */
    public void setGTR(GTR GTR) {
        setChoiceSelect(GTR_CHOICE);
        this.GTR = GTR;
    }

    /** 
     * Check if VirtualCard is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVirtualCard() {
        return choiceSelect == VIRTUAL_CARD_CHOICE;
    }

    /** 
     * Get the 'VirtualCard' element value.
     * 
     * @return value
     */
    public VirtualCard getVirtualCard() {
        return virtualCard;
    }

    /** 
     * Set the 'VirtualCard' element value.
     * 
     * @param virtualCard
     */
    public void setVirtualCard(VirtualCard virtualCard) {
        setChoiceSelect(VIRTUAL_CARD_CHOICE);
        this.virtualCard = virtualCard;
    }

    /** 
     * Check if Other is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOther() {
        return choiceSelect == OTHER_CHOICE;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public OtherFOP getOther() {
        return other;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param other
     */
    public void setOther(OtherFOP other) {
        setChoiceSelect(OTHER_CHOICE);
        this.other = other;
    }

    /** 
     * Check if PayLaterPlan is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPayLaterPlan() {
        return choiceSelect == PAY_LATER_PLAN_CHOICE;
    }

    /** 
     * Get the 'PayLaterPlan' element value.
     * 
     * @return value
     */
    public PayLaterPlan getPayLaterPlan() {
        return payLaterPlan;
    }

    /** 
     * Set the 'PayLaterPlan' element value.
     * 
     * @param payLaterPlan
     */
    public void setPayLaterPlan(PayLaterPlan payLaterPlan) {
        setChoiceSelect(PAY_LATER_PLAN_CHOICE);
        this.payLaterPlan = payLaterPlan;
    }

    /** 
     * Check if LoyaltyProgramRedemption is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLoyaltyProgramRedemption() {
        return choiceSelect == LOYALTY_PROGRAM_REDEMPTION_CHOICE;
    }

    /** 
     * Get the 'LoyaltyProgramRedemption' element value.
     * 
     * @return value
     */
    public LoyaltyProgramRedemption getLoyaltyProgramRedemption() {
        return loyaltyProgramRedemption;
    }

    /** 
     * Set the 'LoyaltyProgramRedemption' element value.
     * 
     * @param loyaltyProgramRedemption
     */
    public void setLoyaltyProgramRedemption(
            LoyaltyProgramRedemption loyaltyProgramRedemption) {
        setChoiceSelect(LOYALTY_PROGRAM_REDEMPTION_CHOICE);
        this.loyaltyProgramRedemption = loyaltyProgramRedemption;
    }

    /** 
     * Get the 'miscFOP' attribute value.
     * 
     * @return value
     */
    public Boolean getMiscFOP() {
        return miscFOP;
    }

    /** 
     * Set the 'miscFOP' attribute value.
     * 
     * @param miscFOP
     */
    public void setMiscFOP(Boolean miscFOP) {
        this.miscFOP = miscFOP;
    }

    /** 
     * Get the 'migrated' attribute value.
     * 
     * @return value
     */
    public Boolean getMigrated() {
        return migrated;
    }

    /** 
     * Set the 'migrated' attribute value.
     * 
     * @param migrated
     */
    public void setMigrated(Boolean migrated) {
        this.migrated = migrated;
    }
}
