
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelProductType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:HotelType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:MultilineTextType" name="RateDescription" minOccurs="0"/>
 *         &lt;xs:element name="HotelPolicy" minOccurs="0">
 *           &lt;!-- Reference to inner class HotelPolicy -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:string" name="SupplementalInformation" minOccurs="0"/>
 *         &lt;xs:element type="ns:PricingElementsType" name="PricingElements" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HotelProductType extends HotelType implements Serializable
{
    private MultilineTextType rateDescription;
    private HotelPolicy hotelPolicy;
    private String supplementalInformation;
    private PricingElementsType pricingElements;

    /** 
     * Get the 'RateDescription' element value.
     * 
     * @return value
     */
    public MultilineTextType getRateDescription() {
        return rateDescription;
    }

    /** 
     * Set the 'RateDescription' element value.
     * 
     * @param rateDescription
     */
    public void setRateDescription(MultilineTextType rateDescription) {
        this.rateDescription = rateDescription;
    }

    /** 
     * Get the 'HotelPolicy' element value.
     * 
     * @return value
     */
    public HotelPolicy getHotelPolicy() {
        return hotelPolicy;
    }

    /** 
     * Set the 'HotelPolicy' element value.
     * 
     * @param hotelPolicy
     */
    public void setHotelPolicy(HotelPolicy hotelPolicy) {
        this.hotelPolicy = hotelPolicy;
    }

    /** 
     * Get the 'SupplementalInformation' element value.
     * 
     * @return value
     */
    public String getSupplementalInformation() {
        return supplementalInformation;
    }

    /** 
     * Set the 'SupplementalInformation' element value.
     * 
     * @param supplementalInformation
     */
    public void setSupplementalInformation(String supplementalInformation) {
        this.supplementalInformation = supplementalInformation;
    }

    /** 
     * Get the 'PricingElements' element value.
     * 
     * @return value
     */
    public PricingElementsType getPricingElements() {
        return pricingElements;
    }

    /** 
     * Set the 'PricingElements' element value.
     * 
     * @param pricingElements
     */
    public void setPricingElements(PricingElementsType pricingElements) {
        this.pricingElements = pricingElements;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelPolicy" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="DepositPolicy" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="GuaranteePolicy" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LateArrivalPolicy" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LateDeparturePolicy" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="CancellationPolicy" minOccurs="0"/>
     *       &lt;xs:element name="CancellationPolicyInfoList" minOccurs="0">
     *         &lt;!-- Reference to inner class CancellationPolicyInfoList -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:MultilineTextType" name="AdditionalPolicy" minOccurs="0"/>
     *       &lt;xs:element name="CheckInCheckOutPolicy" minOccurs="0">
     *         &lt;!-- Reference to inner class CheckInCheckOutPolicy -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HotelPolicy implements Serializable
    {
        private String depositPolicy;
        private String guaranteePolicy;
        private String lateArrivalPolicy;
        private String lateDeparturePolicy;
        private String cancellationPolicy;
        private CancellationPolicyInfoList cancellationPolicyInfoList;
        private MultilineTextType additionalPolicy;
        private CheckInCheckOutPolicy checkInCheckOutPolicy;

        /** 
         * Get the 'DepositPolicy' element value.
         * 
         * @return value
         */
        public String getDepositPolicy() {
            return depositPolicy;
        }

        /** 
         * Set the 'DepositPolicy' element value.
         * 
         * @param depositPolicy
         */
        public void setDepositPolicy(String depositPolicy) {
            this.depositPolicy = depositPolicy;
        }

        /** 
         * Get the 'GuaranteePolicy' element value.
         * 
         * @return value
         */
        public String getGuaranteePolicy() {
            return guaranteePolicy;
        }

        /** 
         * Set the 'GuaranteePolicy' element value.
         * 
         * @param guaranteePolicy
         */
        public void setGuaranteePolicy(String guaranteePolicy) {
            this.guaranteePolicy = guaranteePolicy;
        }

        /** 
         * Get the 'LateArrivalPolicy' element value.
         * 
         * @return value
         */
        public String getLateArrivalPolicy() {
            return lateArrivalPolicy;
        }

        /** 
         * Set the 'LateArrivalPolicy' element value.
         * 
         * @param lateArrivalPolicy
         */
        public void setLateArrivalPolicy(String lateArrivalPolicy) {
            this.lateArrivalPolicy = lateArrivalPolicy;
        }

        /** 
         * Get the 'LateDeparturePolicy' element value. Details specifics of the late departure policy policy
         * 
         * @return value
         */
        public String getLateDeparturePolicy() {
            return lateDeparturePolicy;
        }

        /** 
         * Set the 'LateDeparturePolicy' element value. Details specifics of the late departure policy policy
         * 
         * @param lateDeparturePolicy
         */
        public void setLateDeparturePolicy(String lateDeparturePolicy) {
            this.lateDeparturePolicy = lateDeparturePolicy;
        }

        /** 
         * Get the 'CancellationPolicy' element value.
         * 
         * @return value
         */
        public String getCancellationPolicy() {
            return cancellationPolicy;
        }

        /** 
         * Set the 'CancellationPolicy' element value.
         * 
         * @param cancellationPolicy
         */
        public void setCancellationPolicy(String cancellationPolicy) {
            this.cancellationPolicy = cancellationPolicy;
        }

        /** 
         * Get the 'CancellationPolicyInfoList' element value.
         * 
         * @return value
         */
        public CancellationPolicyInfoList getCancellationPolicyInfoList() {
            return cancellationPolicyInfoList;
        }

        /** 
         * Set the 'CancellationPolicyInfoList' element value.
         * 
         * @param cancellationPolicyInfoList
         */
        public void setCancellationPolicyInfoList(
                CancellationPolicyInfoList cancellationPolicyInfoList) {
            this.cancellationPolicyInfoList = cancellationPolicyInfoList;
        }

        /** 
         * Get the 'AdditionalPolicy' element value.
         * 
         * @return value
         */
        public MultilineTextType getAdditionalPolicy() {
            return additionalPolicy;
        }

        /** 
         * Set the 'AdditionalPolicy' element value.
         * 
         * @param additionalPolicy
         */
        public void setAdditionalPolicy(MultilineTextType additionalPolicy) {
            this.additionalPolicy = additionalPolicy;
        }

        /** 
         * Get the 'CheckInCheckOutPolicy' element value.
         * 
         * @return value
         */
        public CheckInCheckOutPolicy getCheckInCheckOutPolicy() {
            return checkInCheckOutPolicy;
        }

        /** 
         * Set the 'CheckInCheckOutPolicy' element value.
         * 
         * @param checkInCheckOutPolicy
         */
        public void setCheckInCheckOutPolicy(
                CheckInCheckOutPolicy checkInCheckOutPolicy) {
            this.checkInCheckOutPolicy = checkInCheckOutPolicy;
        }
        /** 
         * Details specifics of the cancellation policy, typically the times
        										determining the penalty period and the penalties incurred for cancellation.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancellationPolicyInfoList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="CancelPolicyInfo" maxOccurs="2">
         *         &lt;!-- Reference to inner class CancelPolicyInfo -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CancellationPolicyInfoList implements Serializable
        {
            private List<CancelPolicyInfo> cancelPolicyInfoList = new ArrayList<CancelPolicyInfo>();

            /** 
             * Get the list of 'CancelPolicyInfo' element items.
             * 
             * @return list
             */
            public List<CancelPolicyInfo> getCancelPolicyInfoList() {
                return cancelPolicyInfoList;
            }

            /** 
             * Set the list of 'CancelPolicyInfo' element items.
             * 
             * @param list
             */
            public void setCancelPolicyInfoList(List<CancelPolicyInfo> list) {
                cancelPolicyInfoList = list;
            }
            /** 
             * Contains cancellation information, e.g. additional charges.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CancelPolicyInfo" maxOccurs="2">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:int" name="VersionId" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CancelTime" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="StartWindowHours" minOccurs="0"/>
             *       &lt;xs:element type="xs:unsignedShort" name="NightCount" minOccurs="0"/>
             *       &lt;xs:element type="xs:float" name="Percent" minOccurs="0"/>
             *       &lt;xs:element type="xs:float" name="Amount" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TimeZoneDescription" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CancelPolicyInfo implements Serializable
            {
                private Integer versionId;
                private String cancelTime;
                private String startWindowHours;
                private String nightCount;
                private Float percent;
                private Float amount;
                private String currencyCode;
                private String timeZoneDescription;

                /** 
                 * Get the 'VersionId' element value. Version ID value.
                 * 
                 * @return value
                 */
                public Integer getVersionId() {
                    return versionId;
                }

                /** 
                 * Set the 'VersionId' element value. Version ID value.
                 * 
                 * @param versionId
                 */
                public void setVersionId(Integer versionId) {
                    this.versionId = versionId;
                }

                /** 
                 * Get the 'CancelTime' element value. The time of day the policy window begins/ends.
                 * 
                 * @return value
                 */
                public String getCancelTime() {
                    return cancelTime;
                }

                /** 
                 * Set the 'CancelTime' element value. The time of day the policy window begins/ends.
                 * 
                 * @param cancelTime
                 */
                public void setCancelTime(String cancelTime) {
                    this.cancelTime = cancelTime;
                }

                /** 
                 * Get the 'StartWindowHours' element value. Hours before the day of check-in that the policy window begins,
                															counting back from the specific time returned in CancelTime. This will return
                															as 0 within the first instance of CancelPolicyInfo (since the window extends up
                															until the actual check-in time) and then the actual number of hours the policy
                															window spans for the second instance.
                															Returns with a value of 999 for nonrefundable rooms.
                 * 
                 * @return value
                 */
                public String getStartWindowHours() {
                    return startWindowHours;
                }

                /** 
                 * Set the 'StartWindowHours' element value. Hours before the day of check-in that the policy window begins,
                															counting back from the specific time returned in CancelTime. This will return
                															as 0 within the first instance of CancelPolicyInfo (since the window extends up
                															until the actual check-in time) and then the actual number of hours the policy
                															window spans for the second instance.
                															Returns with a value of 999 for nonrefundable rooms.
                 * 
                 * @param startWindowHours
                 */
                public void setStartWindowHours(String startWindowHours) {
                    this.startWindowHours = startWindowHours;
                }

                /** 
                 * Get the 'NightCount' element value. The number of nights charged as a penalty for cancelling within
                															the policy window. A value of 1 = the first night's value plus tax; 2 = first
                															and second night's individual values plus tax (do not multiply the first
                															night's value).
                 * 
                 * @return value
                 */
                public String getNightCount() {
                    return nightCount;
                }

                /** 
                 * Set the 'NightCount' element value. The number of nights charged as a penalty for cancelling within
                															the policy window. A value of 1 = the first night's value plus tax; 2 = first
                															and second night's individual values plus tax (do not multiply the first
                															night's value).
                 * 
                 * @param nightCount
                 */
                public void setNightCount(String nightCount) {
                    this.nightCount = nightCount;
                }

                /** 
                 * Get the 'Percent' element value. Percentage of the value of the total cost of stay (less taxes
                															and fees) that will be charged as a penalty for cancelling within
                															the policy window
                 * 
                 * @return value
                 */
                public Float getPercent() {
                    return percent;
                }

                /** 
                 * Set the 'Percent' element value. Percentage of the value of the total cost of stay (less taxes
                															and fees) that will be charged as a penalty for cancelling within
                															the policy window
                 * 
                 * @param percent
                 */
                public void setPercent(Float percent) {
                    this.percent = percent;
                }

                /** 
                 * Get the 'Amount' element value. Flat fee to be charged as a penalty for cancelling within
                															the policy window.
                 * 
                 * @return value
                 */
                public Float getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'Amount' element value. Flat fee to be charged as a penalty for cancelling within
                															the policy window.
                 * 
                 * @param amount
                 */
                public void setAmount(Float amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'CurrencyCode' element value. Currency penalties will be charged in.
                 * 
                 * @return value
                 */
                public String getCurrencyCode() {
                    return currencyCode;
                }

                /** 
                 * Set the 'CurrencyCode' element value. Currency penalties will be charged in.
                 * 
                 * @param currencyCode
                 */
                public void setCurrencyCode(String currencyCode) {
                    this.currencyCode = currencyCode;
                }

                /** 
                 * Get the 'TimeZoneDescription' element value. Time zone the property applies to the stated policy period.
                 * 
                 * @return value
                 */
                public String getTimeZoneDescription() {
                    return timeZoneDescription;
                }

                /** 
                 * Set the 'TimeZoneDescription' element value. Time zone the property applies to the stated policy period.
                 * 
                 * @param timeZoneDescription
                 */
                public void setTimeZoneDescription(String timeZoneDescription) {
                    this.timeZoneDescription = timeZoneDescription;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckInCheckOutPolicy" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:time" name="CheckIn"/>
         *         &lt;xs:attribute type="xs:time" name="CheckOut"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CheckInCheckOutPolicy implements Serializable
        {
            private String string;
            private Time checkIn;
            private Time checkOut;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'CheckIn' attribute value. The checkin time policy used to inform guest should check in after this check-in time.
             * 
             * @return value
             */
            public Time getCheckIn() {
                return checkIn;
            }

            /** 
             * Set the 'CheckIn' attribute value. The checkin time policy used to inform guest should check in after this check-in time.
             * 
             * @param checkIn
             */
            public void setCheckIn(Time checkIn) {
                this.checkIn = checkIn;
            }

            /** 
             * Get the 'CheckOut' attribute value. The checkout time policy used to inform that guest needs to check-out by this time
             * 
             * @return value
             */
            public Time getCheckOut() {
                return checkOut;
            }

            /** 
             * Set the 'CheckOut' attribute value. The checkout time policy used to inform that guest needs to check-out by this time
             * 
             * @param checkOut
             */
            public void setCheckOut(Time checkOut) {
                this.checkOut = checkOut;
            }
        }
    }
}
