
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InsuranceCoverage">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="code"/>
 *   &lt;xs:attribute type="xs:string" name="vendorCode"/>
 *   &lt;xs:attribute type="xs:string" name="amount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InsuranceCoverage implements Serializable
{
    private String name;
    private String description;
    private String code;
    private String vendorCode;
    private String amount;

    /** 
     * Get the 'Name' element value. "Name" is used to return the coverage name associated with the particular insurance segment.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. "Name" is used to return the coverage name associated with the particular insurance segment.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Description' element value.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'code' attribute value. coverage code as defined in Sabre system (DU table)
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'code' attribute value. coverage code as defined in Sabre system (DU table)
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'vendorCode' attribute value.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'vendorCode' attribute value.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'amount' attribute value. "Amount" is used to return the coverage amount associated with the particular insurance segment.
     * 
     * @return value
     */
    public String getAmount() {
        return amount;
    }

    /** 
     * Set the 'amount' attribute value. "Amount" is used to return the coverage amount associated with the particular insurance segment.
     * 
     * @param amount
     */
    public void setAmount(String amount) {
        this.amount = amount;
    }
}
