
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerStatusType">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="xs:string" name="CityCode"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="ns:PassengerStatusEnumType" use="required" name="type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerStatusType implements Serializable
{
    private int choiceSelect = -1;
    private static final int STATE_CODE_CHOICE = 0;
    private static final int CITY_CODE_CHOICE = 1;
    private Sequence stateCode;
    private String cityCode;
    private PassengerStatusEnumType type;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if StateCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifStateCode() {
        return choiceSelect == STATE_CODE_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getStateCode() {
        return stateCode;
    }

    /** 
     * Set the sequence value.
     * 
     * @param stateCode
     */
    public void setStateCode(Sequence stateCode) {
        setChoiceSelect(STATE_CODE_CHOICE);
        this.stateCode = stateCode;
    }

    /** 
     * Check if CityCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCityCode() {
        return choiceSelect == CITY_CODE_CHOICE;
    }

    /** 
     * Get the 'CityCode' element value.
     * 
     * @return value
     */
    public String getCityCode() {
        return cityCode;
    }

    /** 
     * Set the 'CityCode' element value.
     * 
     * @param cityCode
     */
    public void setCityCode(String cityCode) {
        setChoiceSelect(CITY_CODE_CHOICE);
        this.cityCode = cityCode;
    }

    /** 
     * Get the 'type' attribute value.
     * 
     * @return value
     */
    public PassengerStatusEnumType getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value.
     * 
     * @param type
     */
    public void setType(PassengerStatusEnumType type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="xs:string" name="StateCode" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="CountryCode"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private String stateCode;
        private String countryCode;

        /** 
         * Get the 'StateCode' element value.
         * 
         * @return value
         */
        public String getStateCode() {
            return stateCode;
        }

        /** 
         * Set the 'StateCode' element value.
         * 
         * @param stateCode
         */
        public void setStateCode(String stateCode) {
            this.stateCode = stateCode;
        }

        /** 
         * Get the 'CountryCode' element value.
         * 
         * @return value
         */
        public String getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' element value.
         * 
         * @param countryCode
         */
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }
    }
}
