
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Specifies a PTC (Passenger Type Code) and the associated number of PTC's -
 for use in specifying passenger lists.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TravelerCountType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:BirthDateType" name="BirthDate" minOccurs="0"/>
 *         &lt;xs:element type="ns:AgeType" name="Age" minOccurs="0"/>
 *         &lt;xs:element type="ns:StateType" name="State" minOccurs="0"/>
 *         &lt;xs:element type="ns:TotalNumberType" name="TotalNumber" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" default="true" name="changeable"/>
 *       &lt;xs:attribute type="xs:int" name="index"/>
 *       &lt;xs:attribute type="xs:integer" name="requestedPassengerIndex"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerTypeQuantityType extends TravelerCountType implements
    Serializable
{
    private BirthDateType birthDate;
    private AgeType age;
    private StateType state;
    private TotalNumberType totalNumber;
    private Boolean changeable;
    private Integer index;
    private BigInteger requestedPassengerIndex;

    /** 
     * Get the 'BirthDate' element value.
     * 
     * @return value
     */
    public BirthDateType getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' element value.
     * 
     * @param birthDate
     */
    public void setBirthDate(BirthDateType birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'Age' element value. Exchange-specific
     * 
     * @return value
     */
    public AgeType getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value. Exchange-specific
     * 
     * @param age
     */
    public void setAge(AgeType age) {
        this.age = age;
    }

    /** 
     * Get the 'State' element value. Exchange-specific
     * 
     * @return value
     */
    public StateType getState() {
        return state;
    }

    /** 
     * Set the 'State' element value. Exchange-specific
     * 
     * @param state
     */
    public void setState(StateType state) {
        this.state = state;
    }

    /** 
     * Get the 'TotalNumber' element value. Exchange-specific
     * 
     * @return value
     */
    public TotalNumberType getTotalNumber() {
        return totalNumber;
    }

    /** 
     * Set the 'TotalNumber' element value. Exchange-specific
     * 
     * @param totalNumber
     */
    public void setTotalNumber(TotalNumberType totalNumber) {
        this.totalNumber = totalNumber;
    }

    /** 
     * Get the 'changeable' attribute value.
     * 
     * @return value
     */
    public Boolean getChangeable() {
        return changeable;
    }

    /** 
     * Set the 'changeable' attribute value.
     * 
     * @param changeable
     */
    public void setChangeable(Boolean changeable) {
        this.changeable = changeable;
    }

    /** 
     * Get the 'index' attribute value. Allows to identify which one of requested passengers this solution relates
                              to.
                          
     * 
     * @return value
     */
    public Integer getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value. Allows to identify which one of requested passengers this solution relates
                              to.
                          
     * 
     * @param index
     */
    public void setIndex(Integer index) {
        this.index = index;
    }

    /** 
     * Get the 'requestedPassengerIndex' attribute value. Allows to identify which one of requested passenger groups from Exchange
                              request this solution relates to.
                          
     * 
     * @return value
     */
    public BigInteger getRequestedPassengerIndex() {
        return requestedPassengerIndex;
    }

    /** 
     * Set the 'requestedPassengerIndex' attribute value. Allows to identify which one of requested passenger groups from Exchange
                              request this solution relates to.
                          
     * 
     * @param requestedPassengerIndex
     */
    public void setRequestedPassengerIndex(BigInteger requestedPassengerIndex) {
        this.requestedPassengerIndex = requestedPassengerIndex;
    }
}
