
package com.sabre.services.res.or.v111;

import java.io.Serializable;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceCache">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProviderName" minOccurs="0"/>
 *     &lt;xs:element name="Comment" minOccurs="0">
 *       &lt;!-- Reference to inner class Comment -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="ProviderRequest" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:any minOccurs="0" processContents="skip" namespace="##any"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="ProviderResponse" minOccurs="0">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:any minOccurs="0" processContents="skip" namespace="##any"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceCache implements Serializable
{
    private String providerName;
    private Comment comment;
    private Element providerRequest;
    private Element providerResponse;

    /** 
     * Get the 'ProviderName' element value. Pricing provider name used to identify pricing provider service
     * 
     * @return value
     */
    public String getProviderName() {
        return providerName;
    }

    /** 
     * Set the 'ProviderName' element value. Pricing provider name used to identify pricing provider service
     * 
     * @param providerName
     */
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    /** 
     * Get the 'Comment' element value.
     * 
     * @return value
     */
    public Comment getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value.
     * 
     * @param comment
     */
    public void setComment(Comment comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'ProviderRequest' element value. Pricing provider request element containing any XML element to store user pricing request
     * 
     * @return value
     */
    public Element getProviderRequest() {
        return providerRequest;
    }

    /** 
     * Set the 'ProviderRequest' element value. Pricing provider request element containing any XML element to store user pricing request
     * 
     * @param providerRequest
     */
    public void setProviderRequest(Element providerRequest) {
        this.providerRequest = providerRequest;
    }

    /** 
     * Get the 'ProviderResponse' element value. Pricing provider response element containing any XML element to store user pricing request
     * 
     * @return value
     */
    public Element getProviderResponse() {
        return providerResponse;
    }

    /** 
     * Set the 'ProviderResponse' element value. Pricing provider response element containing any XML element to store user pricing request
     * 
     * @param providerResponse
     */
    public void setProviderResponse(Element providerResponse) {
        this.providerResponse = providerResponse;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Comment" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="name"/>
     *         &lt;xs:attribute type="xs:string" name="type"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Comment implements Serializable
    {
        private String string;
        private String name;
        private String type;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'name' attribute value. User-defined comment name to identify specific comment
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'name' attribute value. User-defined comment name to identify specific comment
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'type' attribute value. User-defined comment type
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'type' attribute value. User-defined comment type
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }
    }
}
