
package com.sabre.services.res.or.v111;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_11" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingRequestInformationType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AirPriceQualifiersType" name="AirPriceQualifiers" minOccurs="0"/>
 *     &lt;xs:element type="ns:HotelRateQualifiersType" name="HotelRateQualifiers" minOccurs="0"/>
 *     &lt;xs:element type="ns:CarRateQualifiersType" name="CarRateQualifiers" minOccurs="0"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricingRequestInformationType implements Serializable
{
    private int choiceSelect = -1;
    private static final int AIR_PRICE_QUALIFIERS_CHOICE = 0;
    private static final int HOTEL_RATE_QUALIFIERS_CHOICE = 1;
    private static final int CAR_RATE_QUALIFIERS_CHOICE = 2;
    private AirPriceQualifiersType airPriceQualifiers;
    private HotelRateQualifiersType hotelRateQualifiers;
    private CarRateQualifiersType carRateQualifiers;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AirPriceQualifiers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirPriceQualifiers() {
        return choiceSelect == AIR_PRICE_QUALIFIERS_CHOICE;
    }

    /** 
     * Get the 'AirPriceQualifiers' element value.
     * 
     * @return value
     */
    public AirPriceQualifiersType getAirPriceQualifiers() {
        return airPriceQualifiers;
    }

    /** 
     * Set the 'AirPriceQualifiers' element value.
     * 
     * @param airPriceQualifiers
     */
    public void setAirPriceQualifiers(AirPriceQualifiersType airPriceQualifiers) {
        setChoiceSelect(AIR_PRICE_QUALIFIERS_CHOICE);
        this.airPriceQualifiers = airPriceQualifiers;
    }

    /** 
     * Check if HotelRateQualifiers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHotelRateQualifiers() {
        return choiceSelect == HOTEL_RATE_QUALIFIERS_CHOICE;
    }

    /** 
     * Get the 'HotelRateQualifiers' element value.
     * 
     * @return value
     */
    public HotelRateQualifiersType getHotelRateQualifiers() {
        return hotelRateQualifiers;
    }

    /** 
     * Set the 'HotelRateQualifiers' element value.
     * 
     * @param hotelRateQualifiers
     */
    public void setHotelRateQualifiers(
            HotelRateQualifiersType hotelRateQualifiers) {
        setChoiceSelect(HOTEL_RATE_QUALIFIERS_CHOICE);
        this.hotelRateQualifiers = hotelRateQualifiers;
    }

    /** 
     * Check if CarRateQualifiers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCarRateQualifiers() {
        return choiceSelect == CAR_RATE_QUALIFIERS_CHOICE;
    }

    /** 
     * Get the 'CarRateQualifiers' element value.
     * 
     * @return value
     */
    public CarRateQualifiersType getCarRateQualifiers() {
        return carRateQualifiers;
    }

    /** 
     * Set the 'CarRateQualifiers' element value.
     * 
     * @param carRateQualifiers
     */
    public void setCarRateQualifiers(CarRateQualifiersType carRateQualifiers) {
        setChoiceSelect(CAR_RATE_QUALIFIERS_CHOICE);
        this.carRateQualifiers = carRateQualifiers;
    }
}
