
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * List of additional in-stay services which can be paid with the virtual credit card other than the reservation itself
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AuthorizedChargesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AuthorizedCharge" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AuthorizedChargesType implements Serializable
{
    private List<String> authorizedChargeList = new ArrayList<String>();

    /** 
     * Get the list of 'AuthorizedCharge' element items.
     * 
     * @return list
     */
    public List<String> getAuthorizedChargeList() {
        return authorizedChargeList;
    }

    /** 
     * Set the list of 'AuthorizedCharge' element items.
     * 
     * @param list
     */
    public void setAuthorizedChargeList(List<String> list) {
        authorizedChargeList = list;
    }
}
