
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDefinition">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BaggageWeightLimit" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BaggageWeightLimit -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BaggageSizeLimit" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BaggageSizeLimit -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:int" name="FirstOccurrence" minOccurs="0"/>
 *     &lt;xs:element type="xs:int" name="LastOccurrence" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageDefinition implements Serializable
{
    private List<BaggageWeightLimit> baggageWeightLimitList = new ArrayList<BaggageWeightLimit>();
    private List<BaggageSizeLimit> baggageSizeLimitList = new ArrayList<BaggageSizeLimit>();
    private Integer firstOccurrence;
    private Integer lastOccurrence;

    /** 
     * Get the list of 'BaggageWeightLimit' element items.
     * 
     * @return list
     */
    public List<BaggageWeightLimit> getBaggageWeightLimitList() {
        return baggageWeightLimitList;
    }

    /** 
     * Set the list of 'BaggageWeightLimit' element items.
     * 
     * @param list
     */
    public void setBaggageWeightLimitList(List<BaggageWeightLimit> list) {
        baggageWeightLimitList = list;
    }

    /** 
     * Get the list of 'BaggageSizeLimit' element items.
     * 
     * @return list
     */
    public List<BaggageSizeLimit> getBaggageSizeLimitList() {
        return baggageSizeLimitList;
    }

    /** 
     * Set the list of 'BaggageSizeLimit' element items.
     * 
     * @param list
     */
    public void setBaggageSizeLimitList(List<BaggageSizeLimit> list) {
        baggageSizeLimitList = list;
    }

    /** 
     * Get the 'FirstOccurrence' element value. 
                          First occurrence. For example '2' indicates that this ancillary is applicable to the second or
                          subsequent baggage piece of a particular type, in processing order.
                      
     * 
     * @return value
     */
    public Integer getFirstOccurrence() {
        return firstOccurrence;
    }

    /** 
     * Set the 'FirstOccurrence' element value. 
                          First occurrence. For example '2' indicates that this ancillary is applicable to the second or
                          subsequent baggage piece of a particular type, in processing order.
                      
     * 
     * @param firstOccurrence
     */
    public void setFirstOccurrence(Integer firstOccurrence) {
        this.firstOccurrence = firstOccurrence;
    }

    /** 
     * Get the 'LastOccurrence' element value. Last occurrence. For example, '3' would indicate that this ancillary is not
                          applicable to the fourth and subsequent baggage pieces of a particular type, in processing
                          order.
                      
     * 
     * @return value
     */
    public Integer getLastOccurrence() {
        return lastOccurrence;
    }

    /** 
     * Set the 'LastOccurrence' element value. Last occurrence. For example, '3' would indicate that this ancillary is not
                          applicable to the fourth and subsequent baggage pieces of a particular type, in processing
                          order.
                      
     * 
     * @param lastOccurrence
     */
    public void setLastOccurrence(Integer lastOccurrence) {
        this.lastOccurrence = lastOccurrence;
    }
    /** 
     * Baggage weight limit.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageWeightLimit" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:Weight" name="Weight" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LimitType" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaggageWeightLimit implements Serializable
    {
        private Weight weight;
        private String limitType;

        /** 
         * Get the 'Weight' element value. Baggage weight and unit from sub code definition.
         * 
         * @return value
         */
        public Weight getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' element value. Baggage weight and unit from sub code definition.
         * 
         * @param weight
         */
        public void setWeight(Weight weight) {
            this.weight = weight;
        }

        /** 
         * Get the 'LimitType' element value. Limit type. Possible values are: O - over/U - up to.
                                    
         * 
         * @return value
         */
        public String getLimitType() {
            return limitType;
        }

        /** 
         * Set the 'LimitType' element value. Limit type. Possible values are: O - over/U - up to.
                                    
         * 
         * @param limitType
         */
        public void setLimitType(String limitType) {
            this.limitType = limitType;
        }
    }
    /** 
     * Baggage size limit.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageSizeLimit" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:Size" name="BaggageSize" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="LimitType" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BaggageSizeLimit implements Serializable
    {
        private Size baggageSize;
        private String limitType;

        /** 
         * Get the 'BaggageSize' element value. Size and unit from sub code definition.
         * 
         * @return value
         */
        public Size getBaggageSize() {
            return baggageSize;
        }

        /** 
         * Set the 'BaggageSize' element value. Size and unit from sub code definition.
         * 
         * @param baggageSize
         */
        public void setBaggageSize(Size baggageSize) {
            this.baggageSize = baggageSize;
        }

        /** 
         * Get the 'LimitType' element value. Limit type. Possible values are: O - over/U - up to.
                                    
         * 
         * @return value
         */
        public String getLimitType() {
            return limitType;
        }

        /** 
         * Set the 'LimitType' element value. Limit type. Possible values are: O - over/U - up to.
                                    
         * 
         * @param limitType
         */
        public void setLimitType(String limitType) {
            this.limitType = limitType;
        }
    }
}
