
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information about baggage
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageInformationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Allowance" maxOccurs="99">
 *       &lt;!-- Reference to inner class Allowance -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageInformationType implements Serializable
{
    private List<Allowance> allowanceList = new ArrayList<Allowance>();

    /** 
     * Get the list of 'Allowance' element items.
     * 
     * @return list
     */
    public List<Allowance> getAllowanceList() {
        return allowanceList;
    }

    /** 
     * Set the list of 'Allowance' element items.
     * 
     * @param list
     */
    public void setAllowanceList(List<Allowance> list) {
        allowanceList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Allowance" maxOccurs="99">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:int" name="pieces"/>
     *     &lt;xs:attribute type="xs:int" name="weight"/>
     *     &lt;xs:attribute name="unit">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Unit -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Allowance implements Serializable
    {
        private Integer pieces;
        private Integer weight;
        private Unit unit;

        /** 
         * Get the 'pieces' attribute value. Number of Pieces
         * 
         * @return value
         */
        public Integer getPieces() {
            return pieces;
        }

        /** 
         * Set the 'pieces' attribute value. Number of Pieces
         * 
         * @param pieces
         */
        public void setPieces(Integer pieces) {
            this.pieces = pieces;
        }

        /** 
         * Get the 'weight' attribute value. Weight Limit
         * 
         * @return value
         */
        public Integer getWeight() {
            return weight;
        }

        /** 
         * Set the 'weight' attribute value. Weight Limit
         * 
         * @param weight
         */
        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        /** 
         * Get the 'unit' attribute value. Units of the Weight Limit
         * 
         * @return value
         */
        public Unit getUnit() {
            return unit;
        }

        /** 
         * Set the 'unit' attribute value. Units of the Weight Limit
         * 
         * @param unit
         */
        public void setUnit(Unit unit) {
            this.unit = unit;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="kg"/>
         *     &lt;xs:enumeration value="lbs"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Unit implements Serializable {
            KG("kg"), LBS("lbs");
            private final String value;

            private Unit(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Unit convert(String value) {
                for (Unit inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
}
