
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Defines type of Baggage Slot which is used by Baggage AE.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageSlotType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="STANDARD_PIECE"/>
 *     &lt;xs:enumeration value="NON_STANDARD_PIECE"/>
 *     &lt;xs:enumeration value="NOT_APPLICABLE"/>
 *     &lt;xs:enumeration value="UNKNOWN"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BaggageSlotType implements Serializable {
    /** 
     * Baggage Slot for Standard Pieces
     */
    STANDARD_PIECE, /** 
                     * Baggage Slot for Non-Standard Pieces
                     */
    NON_STANDARD_PIECE, /** 
                         * Baggage AE does not represent 'slottable' bag charge
                         */
    NOT_APPLICABLE, /** 
                     * Type of Baggage Slot couldn't be determined
                     */
    UNKNOWN
}
