
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Indicates preferences for choice of airline cabin for a given travel situation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinPrefType">
 *   &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="preferLevel"/>
 *   &lt;xs:attribute type="ns:CabinNameType" name="cabin"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CabinPrefType implements Serializable
{
    private PreferLevelType preferLevel;
    private CabinNameType cabin;

    /** 
     * Get the 'preferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @return value
     */
    public PreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'preferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(PreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'cabin' attribute value. Specify cabin type.
     * 
     * @return value
     */
    public CabinNameType getCabin() {
        return cabin;
    }

    /** 
     * Set the 'cabin' attribute value. Specify cabin type.
     * 
     * @param cabin
     */
    public void setCabin(CabinNameType cabin) {
        this.cabin = cabin;
    }
}
