
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CompanyNameType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="CompanyShortName"/>
 *       &lt;xs:attribute type="xs:string" name="TravelSector"/>
 *       &lt;xs:attribute type="xs:string" name="Code"/>
 *       &lt;xs:attribute type="xs:string" name="CodeContext"/>
 *       &lt;xs:attribute type="xs:string" name="Division"/>
 *       &lt;xs:attribute type="xs:string" name="Department"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CompanyNameType implements Serializable
{
    private String string;
    private String companyShortName;
    private String travelSector;
    private String code;
    private String codeContext;
    private String division;
    private String department;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'CompanyShortName' attribute value. Used to provide the company common name.
    					
     * 
     * @return value
     */
    public String getCompanyShortName() {
        return companyShortName;
    }

    /** 
     * Set the 'CompanyShortName' attribute value. Used to provide the company common name.
    					
     * 
     * @param companyShortName
     */
    public void setCompanyShortName(String companyShortName) {
        this.companyShortName = companyShortName;
    }

    /** 
     * Get the 'TravelSector' attribute value. Refer to OTA Code List Travel Sector (TVS).
    					
     * 
     * @return value
     */
    public String getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'TravelSector' attribute value. Refer to OTA Code List Travel Sector (TVS).
    					
     * 
     * @param travelSector
     */
    public void setTravelSector(String travelSector) {
        this.travelSector = travelSector;
    }

    /** 
     * Get the 'Code' attribute value. Identifies a company by the company code.
    					
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. Identifies a company by the company code.
    					
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'CodeContext' attribute value. Identifies the context of the identifying code,
    						such as DUNS, IATA or internal code, etc.
    					
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'CodeContext' attribute value. Identifies the context of the identifying code,
    						such as DUNS, IATA or internal code, etc.
    					
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'Division' attribute value. The division name or ID with which the contact
    						is associated.
    					
     * 
     * @return value
     */
    public String getDivision() {
        return division;
    }

    /** 
     * Set the 'Division' attribute value. The division name or ID with which the contact
    						is associated.
    					
     * 
     * @param division
     */
    public void setDivision(String division) {
        this.division = division;
    }

    /** 
     * Get the 'Department' attribute value. The department name or ID with which the
    						contact is associated.
    					
     * 
     * @return value
     */
    public String getDepartment() {
        return department;
    }

    /** 
     * Set the 'Department' attribute value. The department name or ID with which the
    						contact is associated.
    					
     * 
     * @param department
     */
    public void setDepartment(String department) {
        this.department = department;
    }
}
