
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FCMIType">
 *   &lt;xs:restriction base="xs:int">
 *     &lt;xs:enumeration value="0"/>
 *     &lt;xs:enumeration value="1"/>
 *     &lt;xs:enumeration value="2"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FCMIType implements Serializable {
    _0("0"), _1("1"), _2("2");
    private final String value;

    private FCMIType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FCMIType convert(String value) {
        for (FCMIType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
