
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GR">
 *   &lt;xs:choice>
 *     &lt;xs:sequence>
 *       &lt;!-- Reference to inner class Sequence -->
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="xs:string" name="Custom" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GR implements Serializable
{
    private int choiceSelect = -1;
    private static final int GGR_CHOICE = 0;
    private static final int CUSTOM_CHOICE = 1;
    private Sequence GGR;
    private String custom;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if GGR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGGR() {
        return choiceSelect == GGR_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getGGR() {
        return GGR;
    }

    /** 
     * Set the sequence value.
     * 
     * @param GGR
     */
    public void setGGR(Sequence GGR) {
        setChoiceSelect(GGR_CHOICE);
        this.GGR = GGR;
    }

    /** 
     * Check if Custom is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustom() {
        return choiceSelect == CUSTOM_CHOICE;
    }

    /** 
     * Get the 'Custom' element value.
     * 
     * @return value
     */
    public String getCustom() {
        return custom;
    }

    /** 
     * Set the 'Custom' element value.
     * 
     * @param custom
     */
    public void setCustom(String custom) {
        setChoiceSelect(CUSTOM_CHOICE);
        this.custom = custom;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="ns:GGR" name="GGR" minOccurs="0" maxOccurs="1"/>
     *   &lt;xs:element type="xs:string" name="Information" minOccurs="0" maxOccurs="1"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private GGR GGR;
        private String information;

        /** 
         * Get the 'GGR' element value.
         * 
         * @return value
         */
        public GGR getGGR() {
            return GGR;
        }

        /** 
         * Set the 'GGR' element value.
         * 
         * @param GGR
         */
        public void setGGR(GGR GGR) {
            this.GGR = GGR;
        }

        /** 
         * Get the 'Information' element value.
         * 
         * @return value
         */
        public String getInformation() {
            return information;
        }

        /** 
         * Set the 'Information' element value.
         * 
         * @param information
         */
        public void setInformation(String information) {
            this.information = information;
        }
    }
}
