
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroundTransportationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:CompanyType" name="Vendor" minOccurs="0"/>
 *     &lt;xs:element type="ns:ServiceType" name="Service" minOccurs="0"/>
 *     &lt;xs:element type="ns:ServiceProviderType" name="ServiceProvider" minOccurs="0"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="StartDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="StopDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LocationDetailsType" name="EndDetails" minOccurs="0"/>
 *     &lt;xs:element type="ns:ExternalReservationType" name="ExternalReservation" minOccurs="0"/>
 *     &lt;xs:element type="ns:RestrictionsType" name="Restrictions" minOccurs="0"/>
 *     &lt;xs:element type="ns:POSType" name="POS"/>
 *     &lt;xs:element type="ns:LoyaltyType" name="AgentLoyalty" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PassengerType" name="Passenger" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:RateQualifierType" name="RateQualifier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ChargesType" name="Charges" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GroundTransportationType implements Serializable
{
    private String statusCode;
    private CompanyType vendor;
    private ServiceType service;
    private ServiceProviderType serviceProvider;
    private LocationDetailsType startDetails;
    private List<LocationDetailsType> stopDetailList = new ArrayList<LocationDetailsType>();
    private LocationDetailsType endDetails;
    private ExternalReservationType externalReservation;
    private RestrictionsType restrictions;
    private POSType POS;
    private List<LoyaltyType> agentLoyaltyList = new ArrayList<LoyaltyType>();
    private List<PassengerType> passengerList = new ArrayList<PassengerType>();
    private List<RateQualifierType> rateQualifierList = new ArrayList<RateQualifierType>();
    private ChargesType charges;

    /** 
     * Get the 'StatusCode' element value.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'Vendor' element value.
     * 
     * @return value
     */
    public CompanyType getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value.
     * 
     * @param vendor
     */
    public void setVendor(CompanyType vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'Service' element value.
     * 
     * @return value
     */
    public ServiceType getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value.
     * 
     * @param service
     */
    public void setService(ServiceType service) {
        this.service = service;
    }

    /** 
     * Get the 'ServiceProvider' element value.
     * 
     * @return value
     */
    public ServiceProviderType getServiceProvider() {
        return serviceProvider;
    }

    /** 
     * Set the 'ServiceProvider' element value.
     * 
     * @param serviceProvider
     */
    public void setServiceProvider(ServiceProviderType serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    /** 
     * Get the 'StartDetails' element value.
     * 
     * @return value
     */
    public LocationDetailsType getStartDetails() {
        return startDetails;
    }

    /** 
     * Set the 'StartDetails' element value.
     * 
     * @param startDetails
     */
    public void setStartDetails(LocationDetailsType startDetails) {
        this.startDetails = startDetails;
    }

    /** 
     * Get the list of 'StopDetails' element items.
     * 
     * @return list
     */
    public List<LocationDetailsType> getStopDetailList() {
        return stopDetailList;
    }

    /** 
     * Set the list of 'StopDetails' element items.
     * 
     * @param list
     */
    public void setStopDetailList(List<LocationDetailsType> list) {
        stopDetailList = list;
    }

    /** 
     * Get the 'EndDetails' element value.
     * 
     * @return value
     */
    public LocationDetailsType getEndDetails() {
        return endDetails;
    }

    /** 
     * Set the 'EndDetails' element value.
     * 
     * @param endDetails
     */
    public void setEndDetails(LocationDetailsType endDetails) {
        this.endDetails = endDetails;
    }

    /** 
     * Get the 'ExternalReservation' element value.
     * 
     * @return value
     */
    public ExternalReservationType getExternalReservation() {
        return externalReservation;
    }

    /** 
     * Set the 'ExternalReservation' element value.
     * 
     * @param externalReservation
     */
    public void setExternalReservation(
            ExternalReservationType externalReservation) {
        this.externalReservation = externalReservation;
    }

    /** 
     * Get the 'Restrictions' element value.
     * 
     * @return value
     */
    public RestrictionsType getRestrictions() {
        return restrictions;
    }

    /** 
     * Set the 'Restrictions' element value.
     * 
     * @param restrictions
     */
    public void setRestrictions(RestrictionsType restrictions) {
        this.restrictions = restrictions;
    }

    /** 
     * Get the 'POS' element value.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the list of 'AgentLoyalty' element items.
     * 
     * @return list
     */
    public List<LoyaltyType> getAgentLoyaltyList() {
        return agentLoyaltyList;
    }

    /** 
     * Set the list of 'AgentLoyalty' element items.
     * 
     * @param list
     */
    public void setAgentLoyaltyList(List<LoyaltyType> list) {
        agentLoyaltyList = list;
    }

    /** 
     * Get the list of 'Passenger' element items.
     * 
     * @return list
     */
    public List<PassengerType> getPassengerList() {
        return passengerList;
    }

    /** 
     * Set the list of 'Passenger' element items.
     * 
     * @param list
     */
    public void setPassengerList(List<PassengerType> list) {
        passengerList = list;
    }

    /** 
     * Get the list of 'RateQualifier' element items.
     * 
     * @return list
     */
    public List<RateQualifierType> getRateQualifierList() {
        return rateQualifierList;
    }

    /** 
     * Set the list of 'RateQualifier' element items.
     * 
     * @param list
     */
    public void setRateQualifierList(List<RateQualifierType> list) {
        rateQualifierList = list;
    }

    /** 
     * Get the 'Charges' element value.
     * 
     * @return value
     */
    public ChargesType getCharges() {
        return charges;
    }

    /** 
     * Set the 'Charges' element value.
     * 
     * @param charges
     */
    public void setCharges(ChargesType charges) {
        this.charges = charges;
    }
}
