
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Basic Property Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HotelInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TierLabels" name="TierLabels" minOccurs="0"/>
 *     &lt;xs:element type="ns:LocationInfo" name="LocationInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amenities" name="Amenities" minOccurs="0"/>
 *     &lt;xs:element type="ns:PropertyTypeInfo" name="PropertyTypeInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="HotelCode"/>
 *   &lt;xs:attribute use="optional" name="CodeContext">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class CodeContext -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GlobalChainCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HotelName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SabreRating"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ChainName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SupplierChainCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SourceHotelCode"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="Ordinal"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class HotelInfoType implements Serializable
{
    private TierLabels tierLabels;
    private LocationInfo locationInfo;
    private Amenities amenities;
    private PropertyTypeInfo propertyTypeInfo;
    private String hotelCode;
    private CodeContext codeContext;
    private String globalChainCode;
    private String hotelName;
    private String brandCode;
    private String sabreRating;
    private String currencyCode;
    private String chainName;
    private String brandName;
    private String supplierChainCode;
    private String sourceHotelCode;
    private Integer ordinal;

    /** 
     * Get the 'TierLabels' element value.
     * 
     * @return value
     */
    public TierLabels getTierLabels() {
        return tierLabels;
    }

    /** 
     * Set the 'TierLabels' element value.
     * 
     * @param tierLabels
     */
    public void setTierLabels(TierLabels tierLabels) {
        this.tierLabels = tierLabels;
    }

    /** 
     * Get the 'LocationInfo' element value.
     * 
     * @return value
     */
    public LocationInfo getLocationInfo() {
        return locationInfo;
    }

    /** 
     * Set the 'LocationInfo' element value.
     * 
     * @param locationInfo
     */
    public void setLocationInfo(LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
    }

    /** 
     * Get the 'Amenities' element value.
     * 
     * @return value
     */
    public Amenities getAmenities() {
        return amenities;
    }

    /** 
     * Set the 'Amenities' element value.
     * 
     * @param amenities
     */
    public void setAmenities(Amenities amenities) {
        this.amenities = amenities;
    }

    /** 
     * Get the 'PropertyTypeInfo' element value.
     * 
     * @return value
     */
    public PropertyTypeInfo getPropertyTypeInfo() {
        return propertyTypeInfo;
    }

    /** 
     * Set the 'PropertyTypeInfo' element value.
     * 
     * @param propertyTypeInfo
     */
    public void setPropertyTypeInfo(PropertyTypeInfo propertyTypeInfo) {
        this.propertyTypeInfo = propertyTypeInfo;
    }

    /** 
     * Get the 'HotelCode' attribute value. Hotel Id from SABRE hotels platform
     * 
     * @return value
     */
    public String getHotelCode() {
        return hotelCode;
    }

    /** 
     * Set the 'HotelCode' attribute value. Hotel Id from SABRE hotels platform
     * 
     * @param hotelCode
     */
    public void setHotelCode(String hotelCode) {
        this.hotelCode = hotelCode;
    }

    /** 
     * Get the 'CodeContext' attribute value.
     * 
     * @return value
     */
    public CodeContext getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'CodeContext' attribute value.
     * 
     * @param codeContext
     */
    public void setCodeContext(CodeContext codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'GlobalChainCode' attribute value.
     * 
     * @return value
     */
    public String getGlobalChainCode() {
        return globalChainCode;
    }

    /** 
     * Set the 'GlobalChainCode' attribute value.
     * 
     * @param globalChainCode
     */
    public void setGlobalChainCode(String globalChainCode) {
        this.globalChainCode = globalChainCode;
    }

    /** 
     * Get the 'HotelName' attribute value.
     * 
     * @return value
     */
    public String getHotelName() {
        return hotelName;
    }

    /** 
     * Set the 'HotelName' attribute value.
     * 
     * @param hotelName
     */
    public void setHotelName(String hotelName) {
        this.hotelName = hotelName;
    }

    /** 
     * Get the 'BrandCode' attribute value.
     * 
     * @return value
     */
    public String getBrandCode() {
        return brandCode;
    }

    /** 
     * Set the 'BrandCode' attribute value.
     * 
     * @param brandCode
     */
    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    /** 
     * Get the 'SabreRating' attribute value.
     * 
     * @return value
     */
    public String getSabreRating() {
        return sabreRating;
    }

    /** 
     * Set the 'SabreRating' attribute value.
     * 
     * @param sabreRating
     */
    public void setSabreRating(String sabreRating) {
        this.sabreRating = sabreRating;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'ChainName' attribute value.
     * 
     * @return value
     */
    public String getChainName() {
        return chainName;
    }

    /** 
     * Set the 'ChainName' attribute value.
     * 
     * @param chainName
     */
    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    /** 
     * Get the 'BrandName' attribute value.
     * 
     * @return value
     */
    public String getBrandName() {
        return brandName;
    }

    /** 
     * Set the 'BrandName' attribute value.
     * 
     * @param brandName
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /** 
     * Get the 'SupplierChainCode' attribute value.
     * 
     * @return value
     */
    public String getSupplierChainCode() {
        return supplierChainCode;
    }

    /** 
     * Set the 'SupplierChainCode' attribute value.
     * 
     * @param supplierChainCode
     */
    public void setSupplierChainCode(String supplierChainCode) {
        this.supplierChainCode = supplierChainCode;
    }

    /** 
     * Get the 'SourceHotelCode' attribute value. Supplier/Source Hotel Id
     * 
     * @return value
     */
    public String getSourceHotelCode() {
        return sourceHotelCode;
    }

    /** 
     * Set the 'SourceHotelCode' attribute value. Supplier/Source Hotel Id
     * 
     * @param sourceHotelCode
     */
    public void setSourceHotelCode(String sourceHotelCode) {
        this.sourceHotelCode = sourceHotelCode;
    }

    /** 
     * Get the 'Ordinal' attribute value.
     * 
     * @return value
     */
    public Integer getOrdinal() {
        return ordinal;
    }

    /** 
     * Set the 'Ordinal' attribute value.
     * 
     * @param ordinal
     */
    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="SABRE"/>
     *     &lt;xs:enumeration value="GLOBAL"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum CodeContext implements Serializable {
        SABRE, GLOBAL
    }
}
