
package com.sabre.services.res.or.v114;

import java.io.Serializable;

/** 
 * Point Of Sale Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LodgingPOSType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Source" minOccurs="0">
 *       &lt;!-- Reference to inner class Source -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LodgingPOSType implements Serializable
{
    private Source source;

    /** 
     * Get the 'Source' element value.
     * 
     * @return value
     */
    public Source getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value.
     * 
     * @param source
     */
    public void setSource(Source source) {
        this.source = source;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:LodgingPOSSource">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="RequestorID" minOccurs="0">
     *             &lt;!-- Reference to inner class RequestorID -->
     *           &lt;/xs:element>
     *           &lt;xs:element type="ns:LodgingAddressType" name="AgencyAddress" minOccurs="0"/>
     *           &lt;xs:element type="ns:ContactType" name="AgencyContact" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Source extends LodgingPOSSource implements Serializable
    {
        private RequestorID requestorID;
        private LodgingAddressType agencyAddress;
        private ContactType agencyContact;

        /** 
         * Get the 'RequestorID' element value.
         * 
         * @return value
         */
        public RequestorID getRequestorID() {
            return requestorID;
        }

        /** 
         * Set the 'RequestorID' element value.
         * 
         * @param requestorID
         */
        public void setRequestorID(RequestorID requestorID) {
            this.requestorID = requestorID;
        }

        /** 
         * Get the 'AgencyAddress' element value. Agency Address is mandatory for GDS Booking
         * 
         * @return value
         */
        public LodgingAddressType getAgencyAddress() {
            return agencyAddress;
        }

        /** 
         * Set the 'AgencyAddress' element value. Agency Address is mandatory for GDS Booking
         * 
         * @param agencyAddress
         */
        public void setAgencyAddress(LodgingAddressType agencyAddress) {
            this.agencyAddress = agencyAddress;
        }

        /** 
         * Get the 'AgencyContact' element value.
         * 
         * @return value
         */
        public ContactType getAgencyContact() {
            return agencyContact;
        }

        /** 
         * Set the 'AgencyContact' element value.
         * 
         * @param agencyContact
         */
        public void setAgencyContact(ContactType agencyContact) {
            this.agencyContact = agencyContact;
        }
        /** 
         * IATA ID is mandatory for GDS Booking
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestorID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:int" use="optional" name="Type"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Id"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="IdContext"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RequestorID implements Serializable
        {
            private Integer type;
            private String id;
            private String idContext;

            /** 
             * Get the 'Type' attribute value. OTA Table UIT : Value 5 for travel agency
             * 
             * @return value
             */
            public Integer getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. OTA Table UIT : Value 5 for travel agency
             * 
             * @param type
             */
            public void setType(Integer type) {
                this.type = type;
            }

            /** 
             * Get the 'Id' attribute value. Agency IATA ID
             * 
             * @return value
             */
            public String getId() {
                return id;
            }

            /** 
             * Set the 'Id' attribute value. Agency IATA ID
             * 
             * @param id
             */
            public void setId(String id) {
                this.id = id;
            }

            /** 
             * Get the 'IdContext' attribute value. Value : IATA
             * 
             * @return value
             */
            public String getIdContext() {
                return idContext;
            }

            /** 
             * Set the 'IdContext' attribute value. Value : IATA
             * 
             * @param idContext
             */
            public void setIdContext(String idContext) {
                this.idContext = idContext;
            }
        }
    }
}
