
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LodgingTaxesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Tax" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Tax -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:TaxGroupsType" name="TaxGroups" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" use="optional" name="Code"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LodgingTaxesType implements Serializable
{
    private List<Tax> taxList = new ArrayList<Tax>();
    private TaxGroupsType taxGroups;
    private Integer code;
    private BigDecimal amount;
    private String currencyCode;

    /** 
     * Get the list of 'Tax' element items.
     * 
     * @return list
     */
    public List<Tax> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items.
     * 
     * @param list
     */
    public void setTaxList(List<Tax> list) {
        taxList = list;
    }

    /** 
     * Get the 'TaxGroups' element value.
     * 
     * @return value
     */
    public TaxGroupsType getTaxGroups() {
        return taxGroups;
    }

    /** 
     * Set the 'TaxGroups' element value.
     * 
     * @param taxGroups
     */
    public void setTaxGroups(TaxGroupsType taxGroups) {
        this.taxGroups = taxGroups;
    }

    /** 
     * Get the 'Code' attribute value. OpenTravel Code List Fee Tax Type (FIT)
     * 
     * @return value
     */
    public Integer getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. OpenTravel Code List Fee Tax Type (FIT)
     * 
     * @param code
     */
    public void setCode(Integer code) {
        this.code = code;
    }

    /** 
     * Get the 'Amount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TaxDescription">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="Text"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:date" name="StartDate"/>
     *     &lt;xs:attribute type="xs:date" name="EndDate"/>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *     &lt;xs:attribute type="xs:decimal" name="Amount"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Tax implements Serializable
    {
        private String taxDescription;
        private Date startDate;
        private Date endDate;
        private String code;
        private BigDecimal amount;
        private String currencyCode;

        /** 
         * Get the 'Text' element value.
         * 
         * @return value
         */
        public String getTaxDescription() {
            return taxDescription;
        }

        /** 
         * Set the 'Text' element value.
         * 
         * @param taxDescription
         */
        public void setTaxDescription(String taxDescription) {
            this.taxDescription = taxDescription;
        }

        /** 
         * Get the 'StartDate' attribute value.
         * 
         * @return value
         */
        public Date getStartDate() {
            return startDate;
        }

        /** 
         * Set the 'StartDate' attribute value.
         * 
         * @param startDate
         */
        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        /** 
         * Get the 'EndDate' attribute value.
         * 
         * @return value
         */
        public Date getEndDate() {
            return endDate;
        }

        /** 
         * Set the 'EndDate' attribute value.
         * 
         * @param endDate
         */
        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'CurrencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'CurrencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
}
