
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Loyalty">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MembershipID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CodeDescription" name="LoyaltyLevel" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="EffectiveDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="ExpireDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element name="Metadata" minOccurs="0">
 *       &lt;!-- Reference to inner class Metadata -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:FrequentFlyer" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Loyalty implements Serializable
{
    private String programName;
    private String membershipID;
    private CodeDescription loyaltyLevel;
    private Date effectiveDate;
    private Date expireDate;
    private List<String> remarkList = new ArrayList<String>();
    private Metadata metadata;
    private FrequentFlyer frequentFlyer;

    /** 
     * Get the 'ProgramName' element value.
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value.
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'MembershipID' element value.
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'MembershipID' element value.
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'LoyaltyLevel' element value.
     * 
     * @return value
     */
    public CodeDescription getLoyaltyLevel() {
        return loyaltyLevel;
    }

    /** 
     * Set the 'LoyaltyLevel' element value.
     * 
     * @param loyaltyLevel
     */
    public void setLoyaltyLevel(CodeDescription loyaltyLevel) {
        this.loyaltyLevel = loyaltyLevel;
    }

    /** 
     * Get the 'EffectiveDate' element value.
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' element value.
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'ExpireDate' element value.
     * 
     * @return value
     */
    public Date getExpireDate() {
        return expireDate;
    }

    /** 
     * Set the 'ExpireDate' element value.
     * 
     * @param expireDate
     */
    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    /** 
     * Get the list of 'Remark' element items.
     * 
     * @return list
     */
    public List<String> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items.
     * 
     * @param list
     */
    public void setRemarkList(List<String> list) {
        remarkList = list;
    }

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public Metadata getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'FrequentFlyer' element value.
     * 
     * @return value
     */
    public FrequentFlyer getFrequentFlyer() {
        return frequentFlyer;
    }

    /** 
     * Set the 'FrequentFlyer' element value.
     * 
     * @param frequentFlyer
     */
    public void setFrequentFlyer(FrequentFlyer frequentFlyer) {
        this.frequentFlyer = frequentFlyer;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Metadata" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:int" name="DisplayIndex" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Metadata implements Serializable
    {
        private Integer displayIndex;

        /** 
         * Get the 'DisplayIndex' element value.
         * 
         * @return value
         */
        public Integer getDisplayIndex() {
            return displayIndex;
        }

        /** 
         * Set the 'DisplayIndex' element value.
         * 
         * @param displayIndex
         */
        public void setDisplayIndex(Integer displayIndex) {
            this.displayIndex = displayIndex;
        }
    }
}
