
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

/** 
 * Defines which meals are included with this rate program
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MealIncludedType">
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Breakfast"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Lunch"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Dinner"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="MealPlanIndicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MealPlanCode"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="GuestCount"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="StartDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="EndDate"/>
 *   &lt;xs:attribute type="xs:int" use="optional" name="NumberOfNights"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="Amount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MealIncludedType implements Serializable
{
    private Boolean breakfast;
    private Boolean lunch;
    private Boolean dinner;
    private Boolean mealPlanIndicator;
    private String mealPlanCode;
    private Integer guestCount;
    private Date startDate;
    private Date endDate;
    private Integer numberOfNights;
    private BigDecimal amount;
    private String currencyCode;

    /** 
     * Get the 'Breakfast' attribute value.
     * 
     * @return value
     */
    public Boolean getBreakfast() {
        return breakfast;
    }

    /** 
     * Set the 'Breakfast' attribute value.
     * 
     * @param breakfast
     */
    public void setBreakfast(Boolean breakfast) {
        this.breakfast = breakfast;
    }

    /** 
     * Get the 'Lunch' attribute value.
     * 
     * @return value
     */
    public Boolean getLunch() {
        return lunch;
    }

    /** 
     * Set the 'Lunch' attribute value.
     * 
     * @param lunch
     */
    public void setLunch(Boolean lunch) {
        this.lunch = lunch;
    }

    /** 
     * Get the 'Dinner' attribute value.
     * 
     * @return value
     */
    public Boolean getDinner() {
        return dinner;
    }

    /** 
     * Set the 'Dinner' attribute value.
     * 
     * @param dinner
     */
    public void setDinner(Boolean dinner) {
        this.dinner = dinner;
    }

    /** 
     * Get the 'MealPlanIndicator' attribute value. When true Meal Plan is included.
     * 
     * @return value
     */
    public Boolean getMealPlanIndicator() {
        return mealPlanIndicator;
    }

    /** 
     * Set the 'MealPlanIndicator' attribute value. When true Meal Plan is included.
     * 
     * @param mealPlanIndicator
     */
    public void setMealPlanIndicator(Boolean mealPlanIndicator) {
        this.mealPlanIndicator = mealPlanIndicator;
    }

    /** 
     * Get the 'MealPlanCode' attribute value. Used to Identify the types of meals included. Refer to Open Travel Code List Meal Plan Type (MPT) list of codes.
     * 
     * @return value
     */
    public String getMealPlanCode() {
        return mealPlanCode;
    }

    /** 
     * Set the 'MealPlanCode' attribute value. Used to Identify the types of meals included. Refer to Open Travel Code List Meal Plan Type (MPT) list of codes.
     * 
     * @param mealPlanCode
     */
    public void setMealPlanCode(String mealPlanCode) {
        this.mealPlanCode = mealPlanCode;
    }

    /** 
     * Get the 'GuestCount' attribute value.
     * 
     * @return value
     */
    public Integer getGuestCount() {
        return guestCount;
    }

    /** 
     * Set the 'GuestCount' attribute value.
     * 
     * @param guestCount
     */
    public void setGuestCount(Integer guestCount) {
        this.guestCount = guestCount;
    }

    /** 
     * Get the 'StartDate' attribute value.
     * 
     * @return value
     */
    public Date getStartDate() {
        return startDate;
    }

    /** 
     * Set the 'StartDate' attribute value.
     * 
     * @param startDate
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    /** 
     * Get the 'EndDate' attribute value.
     * 
     * @return value
     */
    public Date getEndDate() {
        return endDate;
    }

    /** 
     * Set the 'EndDate' attribute value.
     * 
     * @param endDate
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /** 
     * Get the 'NumberOfNights' attribute value.
     * 
     * @return value
     */
    public Integer getNumberOfNights() {
        return numberOfNights;
    }

    /** 
     * Set the 'NumberOfNights' attribute value.
     * 
     * @param numberOfNights
     */
    public void setNumberOfNights(Integer numberOfNights) {
        this.numberOfNights = numberOfNights;
    }

    /** 
     * Get the 'Amount' attribute value.
     * 
     * @return value
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' attribute value.
     * 
     * @param amount
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CurrencyCode' attribute value.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
}
