
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Type" minOccurs="0">
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PersonNameType" name="PersonName" minOccurs="0"/>
 *     &lt;xs:element type="ns:PhoneType" name="Telephone" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="Email" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="9"/>
 *     &lt;xs:element type="xs:int" name="Age" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="DateOfBirth" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ProfileType" name="Profile" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="Gender" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:anySimpleType" name="passengerID"/>
 *   &lt;xs:attribute type="xs:boolean" name="primary"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerType implements Serializable
{
    private Type type;
    private PersonNameType personName;
    private List<PhoneType> telephoneList = new ArrayList<PhoneType>();
    private List<String> emailList = new ArrayList<String>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private Integer age;
    private Date dateOfBirth;
    private List<ProfileType> profileList = new ArrayList<ProfileType>();
    private String gender;
    private String passengerID;
    private Boolean primary;

    /** 
     * Get the 'Type' element value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }

    /** 
     * Get the 'PersonName' element value.
     * 
     * @return value
     */
    public PersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value.
     * 
     * @param personName
     */
    public void setPersonName(PersonNameType personName) {
        this.personName = personName;
    }

    /** 
     * Get the list of 'Telephone' element items.
     * 
     * @return list
     */
    public List<PhoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items.
     * 
     * @param list
     */
    public void setTelephoneList(List<PhoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items.
     * 
     * @return list
     */
    public List<String> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items.
     * 
     * @param list
     */
    public void setEmailList(List<String> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items.
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items.
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the 'Age' element value.
     * 
     * @return value
     */
    public Integer getAge() {
        return age;
    }

    /** 
     * Set the 'Age' element value.
     * 
     * @param age
     */
    public void setAge(Integer age) {
        this.age = age;
    }

    /** 
     * Get the 'DateOfBirth' element value.
     * 
     * @return value
     */
    public Date getDateOfBirth() {
        return dateOfBirth;
    }

    /** 
     * Set the 'DateOfBirth' element value.
     * 
     * @param dateOfBirth
     */
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    /** 
     * Get the list of 'Profile' element items.
     * 
     * @return list
     */
    public List<ProfileType> getProfileList() {
        return profileList;
    }

    /** 
     * Set the list of 'Profile' element items.
     * 
     * @param list
     */
    public void setProfileList(List<ProfileType> list) {
        profileList = list;
    }

    /** 
     * Get the 'Gender' element value. Passenger gender identification ex. Female, Male 
     * 
     * @return value
     */
    public String getGender() {
        return gender;
    }

    /** 
     * Set the 'Gender' element value. Passenger gender identification ex. Female, Male 
     * 
     * @param gender
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /** 
     * Get the 'passengerID' attribute value.
     * 
     * @return value
     */
    public String getPassengerID() {
        return passengerID;
    }

    /** 
     * Set the 'passengerID' attribute value.
     * 
     * @param passengerID
     */
    public void setPassengerID(String passengerID) {
        this.passengerID = passengerID;
    }

    /** 
     * Get the 'primary' attribute value.
     * 
     * @return value
     */
    public Boolean getPrimary() {
        return primary;
    }

    /** 
     * Set the 'primary' attribute value.
     * 
     * @param primary
     */
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Type" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:anySimpleType" name="code"/>
     *         &lt;xs:attribute type="xs:anySimpleType" name="codeContext"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Type implements Serializable
    {
        private String string;
        private String code;
        private String codeContext;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'codeContext' attribute value.
         * 
         * @return value
         */
        public String getCodeContext() {
            return codeContext;
        }

        /** 
         * Set the 'codeContext' attribute value.
         * 
         * @param codeContext
         */
        public void setCodeContext(String codeContext) {
            this.codeContext = codeContext;
        }
    }
}
