
package com.sabre.services.res.or.v114;

import com.sabre.ns.ticketing.pqs.PriceQuoteInfoGetResponse;
import java.io.Serializable;
import org.w3c.dom.Element;

/** 
 * contains PriceQuoteInfo returned from GetPriceQuoteRS
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/pqs/1.0" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteType">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="ns:PriceQuoteInfo" minOccurs="0"/>
 *     &lt;xs:any processContents="strict"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PRICE_QUOTE_INFO_CHOICE = 0;
    private static final int ANY_CHOICE = 1;
    private PriceQuoteInfoGetResponse priceQuoteInfo;
    private Element any;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PriceQuoteInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriceQuoteInfo() {
        return choiceSelect == PRICE_QUOTE_INFO_CHOICE;
    }

    /** 
     * Get the 'PriceQuoteInfo' element value.
     * 
     * @return value
     */
    public PriceQuoteInfoGetResponse getPriceQuoteInfo() {
        return priceQuoteInfo;
    }

    /** 
     * Set the 'PriceQuoteInfo' element value.
     * 
     * @param priceQuoteInfo
     */
    public void setPriceQuoteInfo(PriceQuoteInfoGetResponse priceQuoteInfo) {
        setChoiceSelect(PRICE_QUOTE_INFO_CHOICE);
        this.priceQuoteInfo = priceQuoteInfo;
    }

    /** 
     * Check if Any is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAny() {
        return choiceSelect == ANY_CHOICE;
    }

    /** 
     * Get the any value.
     * 
     * @return value
     */
    public Element getAny() {
        return any;
    }

    /** 
     * Set the any value.
     * 
     * @param any
     */
    public void setAny(Element any) {
        setChoiceSelect(ANY_CHOICE);
        this.any = any;
    }
}
