
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceSummaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DecimalPrice" name="BasePrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:DecimalPrice" name="EquivPrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:TaxesType" name="TotalTaxes" minOccurs="0"/>
 *     &lt;xs:element type="ns:DecimalPrice" name="TotalPrice"/>
 *     &lt;xs:element type="ns:PriceBreakDownType" name="PriceBreakDown" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" name="id"/>
 *   &lt;xs:attribute type="xs:dateTime" name="refreshTimestamp"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceSummaryType implements Serializable
{
    private DecimalPrice basePrice;
    private DecimalPrice equivPrice;
    private TaxesType totalTaxes;
    private DecimalPrice totalPrice;
    private List<PriceBreakDownType> priceBreakDownList = new ArrayList<PriceBreakDownType>();
    private Integer id;
    private Date refreshTimestamp;

    /** 
     * Get the 'BasePrice' element value.
     * 
     * @return value
     */
    public DecimalPrice getBasePrice() {
        return basePrice;
    }

    /** 
     * Set the 'BasePrice' element value.
     * 
     * @param basePrice
     */
    public void setBasePrice(DecimalPrice basePrice) {
        this.basePrice = basePrice;
    }

    /** 
     * Get the 'EquivPrice' element value.
     * 
     * @return value
     */
    public DecimalPrice getEquivPrice() {
        return equivPrice;
    }

    /** 
     * Set the 'EquivPrice' element value.
     * 
     * @param equivPrice
     */
    public void setEquivPrice(DecimalPrice equivPrice) {
        this.equivPrice = equivPrice;
    }

    /** 
     * Get the 'TotalTaxes' element value. Taxes by code summary.
     * 
     * @return value
     */
    public TaxesType getTotalTaxes() {
        return totalTaxes;
    }

    /** 
     * Set the 'TotalTaxes' element value. Taxes by code summary.
     * 
     * @param totalTaxes
     */
    public void setTotalTaxes(TaxesType totalTaxes) {
        this.totalTaxes = totalTaxes;
    }

    /** 
     * Get the 'TotalPrice' element value.
     * 
     * @return value
     */
    public DecimalPrice getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(DecimalPrice totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the list of 'PriceBreakDown' element items. Price per passenger type breakdown.
     * 
     * @return list
     */
    public List<PriceBreakDownType> getPriceBreakDownList() {
        return priceBreakDownList;
    }

    /** 
     * Set the list of 'PriceBreakDown' element items. Price per passenger type breakdown.
     * 
     * @param list
     */
    public void setPriceBreakDownList(List<PriceBreakDownType> list) {
        priceBreakDownList = list;
    }

    /** 
     * Get the 'id' attribute value. Price Refresh id. Positive Integer.
     * 
     * @return value
     */
    public Integer getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. Price Refresh id. Positive Integer.
     * 
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /** 
     * Get the 'refreshTimestamp' attribute value. Price Refresh timestamp.
     * 
     * @return value
     */
    public Date getRefreshTimestamp() {
        return refreshTimestamp;
    }

    /** 
     * Set the 'refreshTimestamp' attribute value. Price Refresh timestamp.
     * 
     * @param refreshTimestamp
     */
    public void setRefreshTimestamp(Date refreshTimestamp) {
        this.refreshTimestamp = refreshTimestamp;
    }
}
