
package com.sabre.services.res.or.v114;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProductBaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="ProductType"/>
 *         &lt;xs:element type="xs:string" name="VendorCode"/>
 *         &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="StartPoint"/>
 *         &lt;xs:element type="xs:dateTime" name="StartDateTime"/>
 *         &lt;xs:element type="xs:string" name="EndPoint" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="EndDateTime" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Text" minOccurs="0" maxOccurs="99"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element type="xs:int" name="SegmentReference"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProductBaseType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PRODUCT_TYPE_CHOICE = 0;
    private static final int SEGMENT_REFERENCE_CHOICE = 1;
    private String productType;
    private String vendorCode;
    private String statusCode;
    private String startPoint;
    private Date startDateTime;
    private String endPoint;
    private Date endDateTime;
    private List<String> textList = new ArrayList<String>();
    private int segmentReference;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ProductType is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProductType() {
        return choiceSelect == PRODUCT_TYPE_CHOICE;
    }

    /** 
     * Get the 'ProductType' element value.
     * 
     * @return value
     */
    public String getProductType() {
        return productType;
    }

    /** 
     * Set the 'ProductType' element value.
     * 
     * @param productType
     */
    public void setProductType(String productType) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.productType = productType;
    }

    /** 
     * Get the 'VendorCode' element value.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'StatusCode' element value.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'StartPoint' element value.
     * 
     * @return value
     */
    public String getStartPoint() {
        return startPoint;
    }

    /** 
     * Set the 'StartPoint' element value.
     * 
     * @param startPoint
     */
    public void setStartPoint(String startPoint) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.startPoint = startPoint;
    }

    /** 
     * Get the 'StartDateTime' element value.
     * 
     * @return value
     */
    public Date getStartDateTime() {
        return startDateTime;
    }

    /** 
     * Set the 'StartDateTime' element value.
     * 
     * @param startDateTime
     */
    public void setStartDateTime(Date startDateTime) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.startDateTime = startDateTime;
    }

    /** 
     * Get the 'EndPoint' element value.
     * 
     * @return value
     */
    public String getEndPoint() {
        return endPoint;
    }

    /** 
     * Set the 'EndPoint' element value.
     * 
     * @param endPoint
     */
    public void setEndPoint(String endPoint) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.endPoint = endPoint;
    }

    /** 
     * Get the 'EndDateTime' element value.
     * 
     * @return value
     */
    public Date getEndDateTime() {
        return endDateTime;
    }

    /** 
     * Set the 'EndDateTime' element value.
     * 
     * @param endDateTime
     */
    public void setEndDateTime(Date endDateTime) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        this.endDateTime = endDateTime;
    }

    /** 
     * Get the list of 'Text' element items.
     * 
     * @return list
     */
    public List<String> getTextList() {
        return textList;
    }

    /** 
     * Set the list of 'Text' element items.
     * 
     * @param list
     */
    public void setTextList(List<String> list) {
        setChoiceSelect(PRODUCT_TYPE_CHOICE);
        textList = list;
    }

    /** 
     * Check if SegmentReference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSegmentReference() {
        return choiceSelect == SEGMENT_REFERENCE_CHOICE;
    }

    /** 
     * Get the 'SegmentReference' element value.
     * 
     * @return value
     */
    public int getSegmentReference() {
        return segmentReference;
    }

    /** 
     * Set the 'SegmentReference' element value.
     * 
     * @param segmentReference
     */
    public void setSegmentReference(int segmentReference) {
        setChoiceSelect(SEGMENT_REFERENCE_CHOICE);
        this.segmentReference = segmentReference;
    }
}
